/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.springconfig.checks;

import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.springconfig.checks.AbstractSensitiveKeyCheck;
import org.sonar.iac.springconfig.tree.api.Tuple;

@Rule(key="S2092")
public class SecureCookieCheck
extends AbstractSensitiveKeyCheck {
    private static final String MESSAGE = "Make sure disabling the \"secure\" flag of this cookie is safe here.";
    private static final Set<String> SENSITIVE_KEYS = Set.of("server.servlet.session.cookie.secure");

    @Override
    protected Set<String> sensitiveKeys() {
        return SENSITIVE_KEYS;
    }

    @Override
    protected void checkValue(CheckContext ctx, Tuple tuple, String value) {
        if ("false".equalsIgnoreCase(value)) {
            ctx.reportIssue(tuple, MESSAGE);
        }
    }
}

