/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.springconfig.checks;

import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.springconfig.checks.AbstractSensitiveKeyCheck;
import org.sonar.iac.springconfig.tree.api.Tuple;

@Rule(key="S4507")
public class DebugFeatureEnabledCheck
extends AbstractSensitiveKeyCheck {
    private static final String MESSAGE = "Make sure this debug feature is deactivated before delivering the code in production.";
    private static final Set<String> SENSITIVE_KEYS = Set.of("debug");

    @Override
    protected Set<String> sensitiveKeys() {
        return SENSITIVE_KEYS;
    }

    @Override
    protected void checkValue(CheckContext ctx, Tuple tuple, String value) {
        if ("true".equalsIgnoreCase(value)) {
            ctx.reportIssue(tuple, MESSAGE);
        }
    }
}

