/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.kubernetes.visitors;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.api.tree.impl.TextRange;
import org.sonar.iac.common.extension.visitors.InputFileContext;
import org.sonar.iac.common.yaml.YamlParser;
import org.sonar.iac.common.yaml.tree.FileTree;
import org.sonar.iac.common.yaml.tree.ScalarTree;
import org.sonar.iac.common.yaml.tree.TupleTree;
import org.sonar.iac.common.yaml.tree.YamlTree;
import org.sonar.iac.helm.tree.api.GoTemplateTree;
import org.sonar.iac.helm.tree.utils.GoTemplateAstHelper;
import org.sonar.iac.helm.tree.utils.ValuePath;
import org.sonar.iac.kubernetes.visitors.HelmInputFileContext;

public final class SecondaryLocationLocator {
    private static final Logger LOG = LoggerFactory.getLogger(SecondaryLocationLocator.class);
    private static final YamlParser PARSER = new YamlParser();

    private SecondaryLocationLocator() {
    }

    public static List<SecondaryLocation> findSecondaryLocationsInAdditionalFiles(InputFileContext inputFileContext, TextRange shiftedTextRange) {
        if (inputFileContext instanceof HelmInputFileContext) {
            HelmInputFileContext helmContext = (HelmInputFileContext)inputFileContext;
            LOG.trace("Find secondary location for issue in additional files for textRange {} in file {}", (Object)shiftedTextRange, (Object)inputFileContext.inputFile);
            return new ArrayList<SecondaryLocation>(SecondaryLocationLocator.doFindSecondaryLocationsInAdditionalFiles(helmContext, shiftedTextRange));
        }
        return new ArrayList<SecondaryLocation>();
    }

    static List<SecondaryLocation> doFindSecondaryLocationsInAdditionalFiles(HelmInputFileContext helmContext, TextRange primaryLocationTextRange) {
        GoTemplateTree ast = helmContext.getGoTemplateTree();
        InputFile valuesFile = helmContext.getValuesFile();
        String sourceWithComments = helmContext.getSourceWithComments();
        if (ast == null || valuesFile == null || sourceWithComments == null) {
            return List.of();
        }
        ArrayList<SecondaryLocation> secondaryLocations = new ArrayList<SecondaryLocation>();
        try {
            List<ValuePath> valuePaths = GoTemplateAstHelper.findValuePaths(ast, primaryLocationTextRange, sourceWithComments);
            for (ValuePath valuePath : valuePaths) {
                TextRange secondaryTextRange = SecondaryLocationLocator.toTextRangeInValuesFile(valuePath, helmContext);
                if (secondaryTextRange == null) continue;
                secondaryLocations.add(new SecondaryLocation(secondaryTextRange, "This value is used in a noncompliant part of a template", valuesFile.toString()));
            }
        }
        catch (IOException e) {
            LOG.debug("Failed to find secondary locations in additional file {}", (Object)valuesFile, (Object)e);
        }
        return secondaryLocations;
    }

    @CheckForNull
    static TextRange toTextRangeInValuesFile(ValuePath valuePath, HelmInputFileContext inputFileContext) throws IOException {
        InputFile valuesFile = inputFileContext.getValuesFile();
        FileTree valuesFileTree = SecondaryLocationLocator.buildTreeFrom(valuesFile);
        List<String> path = SecondaryLocationLocator.filteredPaths(valuePath);
        if (valuesFileTree == null || valuesFileTree.documents().isEmpty() || path.isEmpty()) {
            return null;
        }
        YamlTree node = valuesFileTree.documents().get(0);
        for (String pathPart : path) {
            Tree child;
            Iterator<Tree> iterator = node.children().iterator();
            while (iterator.hasNext() && (node = SecondaryLocationLocator.findByKey(child = iterator.next(), pathPart)) == null) {
            }
            if (node != null) continue;
            return null;
        }
        return node.textRange();
    }

    @CheckForNull
    private static FileTree buildTreeFrom(@Nullable InputFile yamlFile) throws IOException {
        String valuesFileContent;
        if (yamlFile != null && !(valuesFileContent = yamlFile.contents()).isBlank()) {
            return (FileTree)PARSER.parse(valuesFileContent, null);
        }
        return null;
    }

    private static List<String> filteredPaths(ValuePath valuePath) {
        List<String> path = valuePath.path();
        return switch (valuePath.path().get(0)) {
            case "Values" -> path.subList(1, path.size());
            case "Chart", "Release" -> List.of();
            default -> valuePath.path();
        };
    }

    @CheckForNull
    private static YamlTree findByKey(Tree node, String key) {
        ScalarTree scalarTree;
        TupleTree tuple;
        YamlTree yamlTree;
        if (node instanceof TupleTree && (yamlTree = (tuple = (TupleTree)node).key()) instanceof ScalarTree && (scalarTree = (ScalarTree)yamlTree).value().equals(key)) {
            return tuple.value();
        }
        return null;
    }
}

