/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.kubernetes.plugin.predicates;

import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.FilePredicates;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.iac.kubernetes.plugin.predicates.HelmProjectMemberPredicate;
import org.sonar.iac.kubernetes.plugin.predicates.KubernetesFilePredicate;

public class KubernetesOrHelmFilePredicate
implements FilePredicate {
    private final FilePredicate delegate;

    public KubernetesOrHelmFilePredicate(SensorContext sensorContext) {
        this.delegate = sensorContext.fileSystem().predicates().or(KubernetesOrHelmFilePredicate.yamlK8sOrHelmFilePredicate(sensorContext), KubernetesOrHelmFilePredicate.tplHelmFilePredicate(sensorContext));
    }

    @Override
    public boolean apply(InputFile inputFile) {
        return this.delegate.apply(inputFile);
    }

    private static FilePredicate yamlK8sOrHelmFilePredicate(SensorContext sensorContext) {
        FilePredicates predicates = sensorContext.fileSystem().predicates();
        FilePredicate helmTemplatePredicate = predicates.and(predicates.matchesPathPattern("**/templates/**"), (FilePredicate)new HelmProjectMemberPredicate(sensorContext));
        FilePredicate valuesYamlOrChartYamlPredicate = predicates.and(predicates.matchesPathPatterns(new String[]{"**/values.yaml", "**/values.yml", "**/Chart.yaml"}), (FilePredicate)new HelmProjectMemberPredicate(sensorContext));
        return predicates.and(predicates.hasLanguage("yaml"), predicates.or(new KubernetesFilePredicate(), helmTemplatePredicate, valuesYamlOrChartYamlPredicate));
    }

    private static FilePredicate tplHelmFilePredicate(SensorContext sensorContext) {
        FilePredicates predicates = sensorContext.fileSystem().predicates();
        return predicates.and(predicates.matchesPathPattern("**/templates/*.tpl"), (FilePredicate)new HelmProjectMemberPredicate(sensorContext));
    }
}

