/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.kubernetes.plugin;

import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesParserStatistics {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesParserStatistics.class);
    private int pureKubernetesFileCount;
    private int pureKubernetesParsedFileCount;
    private int helmFileCount;
    private int helmParsedFileCount;

    public <T> T recordPureKubernetesFile(Supplier<T> o) {
        ++this.pureKubernetesFileCount;
        T v = o.get();
        ++this.pureKubernetesParsedFileCount;
        return v;
    }

    public <T> T recordHelmFile(Supplier<T> o) {
        ++this.helmFileCount;
        T v = o.get();
        ++this.helmParsedFileCount;
        return v;
    }

    public void logStatistics() {
        if (this.pureKubernetesFileCount != 0 || this.helmFileCount != 0) {
            LOG.debug("Kubernetes Parsing Statistics: Pure Kubernetes files count: {}, parsed: {}, not parsed: {}; Helm files count: {}, parsed: {}, not parsed: {}", this.pureKubernetesFileCount, this.pureKubernetesParsedFileCount, this.pureKubernetesFileCount - this.pureKubernetesParsedFileCount, this.helmFileCount, this.helmParsedFileCount, this.helmFileCount - this.helmParsedFileCount);
        }
    }
}

