/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.kubernetes.plugin;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.iac.common.extension.ParseException;
import org.sonar.iac.helm.HelmEvaluator;
import org.sonar.iac.helm.HelmFileSystem;
import org.sonar.iac.helm.LineNumberCommentInserter;
import org.sonar.iac.helm.LineNumberCommentRemover;
import org.sonar.iac.helm.protobuf.TemplateEvaluationResult;
import org.sonar.iac.helm.tree.impl.GoTemplateTreeImpl;
import org.sonar.iac.helm.utils.OperatingSystemUtils;
import org.sonar.iac.kubernetes.visitors.HelmInputFileContext;
import org.sonar.iac.kubernetes.visitors.LocationShifter;

public class HelmProcessor {
    public static final List<String> LINE_SEPARATORS = List.of("\n", "\r\n", "\r", "\u2028", "\u2029");
    private static final Logger LOG = LoggerFactory.getLogger(HelmProcessor.class);
    private final HelmEvaluator helmEvaluator;
    private final HelmFileSystem helmFilesystem;
    private boolean isEvaluatorInitialized;

    public HelmProcessor(HelmEvaluator helmEvaluator, HelmFileSystem helmFilesystem) {
        this.helmEvaluator = helmEvaluator;
        this.helmFilesystem = helmFilesystem;
    }

    public static boolean isHelmEvaluatorExecutableAvailable() {
        return OperatingSystemUtils.getCurrentPlatformIfSupported().isPresent();
    }

    public void initialize() {
        try {
            this.helmEvaluator.initialize();
            this.isEvaluatorInitialized = true;
        }
        catch (IOException e) {
            LOG.debug("Failed to initialize Helm evaluator, analysis of Helm files will be disabled", e);
        }
    }

    public boolean isHelmEvaluatorInitialized() {
        return this.isEvaluatorInitialized;
    }

    public String process(String source, HelmInputFileContext inputFileContext) {
        LocationShifter.readLinesSizes(source, inputFileContext);
        String evaluatedSource = this.processHelmTemplate(source, inputFileContext);
        return evaluatedSource == null ? "" : LineNumberCommentRemover.cleanSource(evaluatedSource, inputFileContext);
    }

    @CheckForNull
    String processHelmTemplate(String source, HelmInputFileContext inputFileContext) {
        if (!this.isHelmEvaluatorInitialized()) {
            throw new IllegalStateException("Attempt to process Helm template with uninitialized Helm evaluator");
        }
        InputFile inputFile = inputFileContext.inputFile;
        if (source.isBlank()) {
            LOG.debug("The file {} is blank, skipping evaluation", (Object)inputFile);
            return null;
        }
        String sourceWithComments = LineNumberCommentInserter.addLineComments(source);
        inputFileContext.setSourceWithComments(sourceWithComments);
        inputFileContext.setAdditionalFiles(this.helmFilesystem.getRelatedHelmFiles(inputFileContext.inputFile));
        Map<String, String> fileContents = HelmProcessor.validateAndReadFiles(inputFileContext);
        String path = this.helmFilesystem.getFileRelativePath(inputFileContext);
        return this.evaluateHelmTemplate(path, inputFileContext, sourceWithComments, fileContents);
    }

    static Map<String, String> validateAndReadFiles(HelmInputFileContext inputFileContext) {
        if (HelmProcessor.containsLineBreak(inputFileContext.inputFile.filename())) {
            throw HelmProcessor.parseExceptionFor(inputFileContext.inputFile, "File name contains line break", null);
        }
        if (inputFileContext.getAdditionalFiles().keySet().stream().anyMatch(HelmProcessor::containsLineBreak)) {
            inputFileContext.setAdditionalFiles(inputFileContext.getAdditionalFiles().entrySet().stream().filter(entry -> !HelmProcessor.containsLineBreak((String)entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
            LOG.debug("Some additional files have names containing line breaks, skipping them");
        }
        if (!inputFileContext.hasAdditionalFile("values.yaml") && !inputFileContext.hasAdditionalFile("values.yml")) {
            throw HelmProcessor.parseExceptionFor(inputFileContext.inputFile, "Failed to find values file", null);
        }
        Map<String, InputFile> files = inputFileContext.getAdditionalFiles();
        HashMap<String, String> fileContents = new HashMap<String, String>(files.size());
        for (Map.Entry<String, InputFile> filenameToInputFile : files.entrySet()) {
            String fileContent;
            InputFile additionalInputFile = filenameToInputFile.getValue();
            try {
                fileContent = additionalInputFile.contents();
            }
            catch (IOException e) {
                throw HelmProcessor.parseExceptionFor(inputFileContext.inputFile, "Failed to read file at " + additionalInputFile, e.getMessage());
            }
            fileContents.put(filenameToInputFile.getKey(), fileContent);
        }
        return fileContents;
    }

    String evaluateHelmTemplate(String path, HelmInputFileContext inputFileContext, String content, Map<String, String> templateDependencies) {
        InputFile inputFile = inputFileContext.inputFile;
        try {
            TemplateEvaluationResult templateEvaluationResult = this.helmEvaluator.evaluateTemplate(path, content, templateDependencies);
            inputFileContext.setGoTemplateTree(GoTemplateTreeImpl.fromPbTree(templateEvaluationResult.getAst()));
            return templateEvaluationResult.getTemplate();
        }
        catch (IOException | IllegalStateException e) {
            throw HelmProcessor.parseExceptionFor(inputFile, "Template evaluation failed", e.getMessage());
        }
    }

    private static ParseException parseExceptionFor(InputFile inputFile, String cause, @Nullable String details) {
        return new ParseException("Failed to evaluate Helm file " + inputFile + ": " + cause, null, details);
    }

    private static boolean containsLineBreak(String filename) {
        return LINE_SEPARATORS.stream().anyMatch(filename::contains);
    }
}

