/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.kubernetes.checks;

import java.util.List;
import java.util.function.Predicate;
import org.sonar.check.Rule;
import org.sonar.iac.common.checks.TextUtils;
import org.sonar.iac.common.yaml.TreePredicates;
import org.sonar.iac.common.yaml.object.BlockObject;
import org.sonar.iac.common.yaml.tree.TupleTree;
import org.sonar.iac.common.yaml.tree.YamlTree;
import org.sonar.iac.kubernetes.checks.AbstractKubernetesObjectCheck;

@Rule(key="S6473")
public class ExposedAdministrationServicesCheck
extends AbstractKubernetesObjectCheck {
    private static final String MESSAGE = "Make sure that exposing administration services is safe here.";
    private static final String KIND_POD = "Pod";
    private static final String KIND_SERVICE = "Service";
    private static final List<String> KIND_WITH_TEMPLATE = List.of("DaemonSet", "Deployment", "Job", "ReplicaSet", "ReplicationController", "StatefulSet", "CronJob");
    private static final List<String> SENSITIVE_PORTS = List.of("22", "23", "3389", "5800", "5900");

    @Override
    void registerObjectCheck() {
        this.register(KIND_POD, (BlockObject pod) -> pod.blocks("containers").forEach(container -> ExposedAdministrationServicesCheck.reportOnSensitivePorts(container, "containerPort")));
        this.register(KIND_WITH_TEMPLATE, (BlockObject obj) -> obj.block("template").block("spec").blocks("containers").forEach(container -> ExposedAdministrationServicesCheck.reportOnSensitivePorts(container, "containerPort")));
        this.register(KIND_SERVICE, (BlockObject service) -> {
            if (ExposedAdministrationServicesCheck.isLoadBalancerService(service)) {
                ExposedAdministrationServicesCheck.reportOnSensitivePorts(service, "targetPort");
            }
        });
    }

    private static void reportOnSensitivePorts(BlockObject container, String sensitiveKey) {
        container.blocks("ports").forEach(port -> port.attribute(sensitiveKey).reportIfValue(ExposedAdministrationServicesCheck.isSensitivePort(), MESSAGE));
    }

    private static Predicate<YamlTree> isSensitivePort() {
        return t -> TextUtils.matchesValue(t, SENSITIVE_PORTS::contains).isTrue();
    }

    private static boolean isLoadBalancerService(BlockObject service) {
        TupleTree typeTree = (TupleTree)service.attribute((String)"type").tree;
        if (typeTree != null) {
            return TreePredicates.isEqualTo("LoadBalancer").test(typeTree.value());
        }
        return false;
    }
}

