/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.helm.utils;

import java.util.Locale;
import java.util.Optional;
import java.util.Set;

public final class OperatingSystemUtils {
    public static final Set<String> SUPPORTED_PLATFORMS = Set.of("darwin-amd64", "darwin-arm64", "windows-amd64", "linux-amd64");

    private OperatingSystemUtils() {
    }

    public static Optional<String> getCurrentPlatformIfSupported() {
        String platform = OperatingSystemUtils.getNormalizedOsName(System.getProperty("os.name")) + "-" + OperatingSystemUtils.getNormalizedArchName(System.getProperty("os.arch"));
        return Optional.of(platform).filter(SUPPORTED_PLATFORMS::contains);
    }

    static String getNormalizedOsName(String operatingSystem) {
        if ((operatingSystem = operatingSystem.toLowerCase(Locale.ROOT)).startsWith("mac") || operatingSystem.startsWith("darwin")) {
            operatingSystem = "darwin";
        } else if (operatingSystem.startsWith("win")) {
            operatingSystem = "windows";
        } else if (operatingSystem.startsWith("linux")) {
            operatingSystem = "linux";
        } else {
            throw new IllegalStateException("Unsupported OS: " + operatingSystem);
        }
        return operatingSystem;
    }

    static String getNormalizedArchName(String architecture) {
        if ("x86_64".equals(architecture = architecture.toLowerCase(Locale.ROOT)) || "amd64".equals(architecture)) {
            architecture = "amd64";
        } else if ("aarch64".equals(architecture) || "arm64".equals(architecture)) {
            architecture = "arm64";
        } else {
            throw new IllegalStateException("Unsupported architecture: " + architecture);
        }
        return architecture;
    }
}

