/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.helm;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class LineNumberCommentInserter {
    private static final String NEW_LINE = "\\n\\r\\u2028\\u2029";
    private static final Pattern LINE_PATTERN = Pattern.compile("(?<lineContent>[^\\n\\r\\u2028\\u2029]*+)(?<newLine>\\r\\n|[\\n\\r\\u2028\\u2029])");
    private static final int DOUBLE_BRACE_SIZE = 2;

    private LineNumberCommentInserter() {
    }

    public static String addLineComments(String content) {
        StringBuilder sb = new StringBuilder();
        int lineCounter = 0;
        Matcher matcher = LINE_PATTERN.matcher(content);
        int lastIndex = 0;
        int goTemplateStartLine = -1;
        while (matcher.find()) {
            ++lineCounter;
            String lineContent = matcher.group("lineContent");
            sb.append(lineContent);
            if (goTemplateStartLine == -1 && LineNumberCommentInserter.getNumberOfUnmatchedDoubleOpeningBraces(lineContent) == 0) {
                sb.append(LineNumberCommentInserter.commentLineNumber(lineCounter));
            } else if (goTemplateStartLine == -1 && LineNumberCommentInserter.getNumberOfUnmatchedDoubleOpeningBraces(lineContent) > 0) {
                goTemplateStartLine = lineCounter;
            } else if (LineNumberCommentInserter.getNumberOfUnmatchedDoubleOpeningBraces(lineContent) < 0) {
                sb.append(LineNumberCommentInserter.commentMultilineNumber(goTemplateStartLine, lineCounter));
                goTemplateStartLine = -1;
            }
            sb.append(matcher.group("newLine"));
            lastIndex = matcher.end();
        }
        String lastLine = content.substring(lastIndex);
        sb.append(lastLine);
        if (goTemplateStartLine != -1) {
            sb.append(LineNumberCommentInserter.commentMultilineNumber(goTemplateStartLine, lineCounter + 1));
        } else {
            sb.append(LineNumberCommentInserter.commentLineNumber(lineCounter + 1));
        }
        return sb.toString();
    }

    static int getNumberOfUnmatchedDoubleOpeningBraces(String line) {
        int count = 0;
        int index = 0;
        while (index < line.length() - 1) {
            if ("{{".equals(line.substring(index, index + 2))) {
                ++count;
                index += 2;
                continue;
            }
            if ("}}".equals(line.substring(index, index + 2))) {
                --count;
                index += 2;
                continue;
            }
            ++index;
        }
        return count;
    }

    private static String commentLineNumber(int number) {
        return " #" + number;
    }

    private static String commentMultilineNumber(int startLine, int endLine) {
        return " #" + startLine + ":" + endLine;
    }
}

