/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.helm;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.FilePredicates;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.iac.common.extension.ParseException;
import org.sonar.iac.common.extension.visitors.InputFileContext;

public final class HelmFileSystem {
    private static final Set<String> INCLUDED_EXTENSIONS = Set.of("yaml", "yml", "tpl", "txt", "toml", "properties");
    private final FileSystem fileSystem;

    public HelmFileSystem(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    public String getFileRelativePath(InputFileContext inputFileContext) {
        String fileRelativePath;
        InputFile inputFile = inputFileContext.inputFile;
        Path filePath = Path.of(inputFile.uri());
        Path chartRootDirectory = HelmFileSystem.retrieveHelmProjectFolder(filePath, this.fileSystem);
        if (chartRootDirectory == null) {
            fileRelativePath = inputFile.filename();
        } else {
            fileRelativePath = chartRootDirectory.relativize(filePath).normalize().toString();
            fileRelativePath = HelmFileSystem.normalizeToUnixPathSeparator(fileRelativePath);
        }
        return fileRelativePath;
    }

    public Map<String, InputFile> getRelatedHelmFiles(InputFile inputFile) {
        Path helmDirectoryPath = this.retrieveHelmProjectFolder(Path.of(inputFile.uri()));
        if (helmDirectoryPath == null) {
            throw new ParseException("Failed to evaluate Helm file " + inputFile + ": Failed to resolve Helm project directory", null, null);
        }
        FilePredicate additionalHelmFilesPredicate = this.additionalHelmDependenciesPredicate(inputFile, helmDirectoryPath);
        Iterable<InputFile> inputFiles = this.fileSystem.inputFiles(additionalHelmFilesPredicate);
        HashMap<String, InputFile> result = new HashMap<String, InputFile>();
        for (InputFile additionalFile : inputFiles) {
            String fileName = HelmFileSystem.resolveToInputFile(helmDirectoryPath, additionalFile);
            fileName = HelmFileSystem.normalizeToUnixPathSeparator(fileName);
            result.put(fileName, additionalFile);
        }
        return result;
    }

    FilePredicate additionalHelmDependenciesPredicate(InputFile inputFile, Path helmProjectDirectoryPath) {
        FilePredicates predicates = this.fileSystem.predicates();
        Path basePath = this.fileSystem.baseDir().toPath();
        Path relativizedPath = basePath.relativize(helmProjectDirectoryPath);
        String pathPattern = relativizedPath + File.separator + "**";
        return predicates.and(predicates.matchesPathPattern(pathPattern), HelmFileSystem.extensionPredicate(predicates), predicates.not(predicates.hasURI(inputFile.uri())));
    }

    private static FilePredicate extensionPredicate(FilePredicates predicates) {
        Set<FilePredicate> extensionPredicates = INCLUDED_EXTENSIONS.stream().map(predicates::hasExtension).collect(Collectors.toSet());
        return predicates.or(extensionPredicates);
    }

    public static Path retrieveHelmProjectFolder(Path inputFilePath, FileSystem fileSystem) {
        Path helmProjectDirectoryPath;
        Path baseDirPath = fileSystem.baseDir().toPath();
        for (helmProjectDirectoryPath = inputFilePath; helmProjectDirectoryPath != null && helmProjectDirectoryPath.startsWith(baseDirPath) && !Files.exists(helmProjectDirectoryPath.resolve("Chart.yaml"), new LinkOption[0]); helmProjectDirectoryPath = helmProjectDirectoryPath.getParent()) {
        }
        if (helmProjectDirectoryPath != null && !helmProjectDirectoryPath.startsWith(baseDirPath)) {
            return null;
        }
        return helmProjectDirectoryPath;
    }

    @CheckForNull
    public Path retrieveHelmProjectFolder(Path inputFilePath) {
        return HelmFileSystem.retrieveHelmProjectFolder(inputFilePath, this.fileSystem);
    }

    private static String resolveToInputFile(Path helmDirectoryPath, InputFile additionalFile) {
        return helmDirectoryPath.relativize(Path.of(additionalFile.uri())).toString();
    }

    public static String normalizeToUnixPathSeparator(String filename) {
        return filename.replace('\\', '/');
    }
}

