/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.docker.symbols;

import java.util.ArrayList;
import java.util.List;
import org.sonar.iac.docker.symbols.Scope;
import org.sonar.iac.docker.symbols.Usage;
import org.sonar.iac.docker.tree.api.DockerTree;
import org.sonar.iac.docker.tree.api.HasSymbol;

public class Symbol {
    private final String name;
    private final List<Usage> usages;

    public Symbol(String name) {
        this.name = name;
        this.usages = new ArrayList<Usage>();
    }

    public Symbol(Symbol orgSymbol) {
        this.name = orgSymbol.name;
        this.usages = new ArrayList<Usage>(orgSymbol.usages);
    }

    public void addUsage(Scope scope, DockerTree tree, Usage.Kind kind) {
        Usage usage = new Usage(scope, tree, kind);
        this.usages.add(usage);
        if (tree instanceof HasSymbol) {
            HasSymbol treeWithSymbol = (HasSymbol)((Object)tree);
            treeWithSymbol.setSymbol(new Symbol(this));
        }
    }

    public String name() {
        return this.name;
    }

    public List<Usage> usages() {
        return this.usages;
    }

    public Scope.Kind lastDeclarationScope() {
        Scope.Kind declarationScope = Scope.Kind.IMAGE;
        for (int i = this.usages.size() - 1; i >= 0; --i) {
            Usage usage = this.usages.get(i);
            if (Usage.Kind.ASSIGNMENT != usage.kind()) continue;
            declarationScope = usage.scope().kind();
            break;
        }
        return declarationScope;
    }
}

