/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.docker.reports.hadolint;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.rule.Severity;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.issue.NewExternalIssue;
import org.sonar.api.batch.sensor.issue.NewIssueLocation;
import org.sonar.api.rules.RuleType;
import org.sonar.iac.common.reports.AbstractJsonReportImporter;
import org.sonar.iac.common.warnings.AnalysisWarningsWrapper;
import org.sonar.iac.docker.plugin.HadolintRulesDefinition;
import org.sonar.iac.docker.reports.hadolint.ReportFormat;
import org.sonarsource.analyzer.commons.internal.json.simple.JSONArray;
import org.sonarsource.analyzer.commons.internal.json.simple.JSONObject;
import org.sonarsource.analyzer.commons.internal.json.simple.parser.ParseException;

public class HadolintImporter
extends AbstractJsonReportImporter {
    private static final String MESSAGE_PREFIX = "Hadolint report importing: ";

    public HadolintImporter(SensorContext context, AnalysisWarningsWrapper analysisWarnings) {
        super(context, analysisWarnings, MESSAGE_PREFIX);
    }

    @Override
    protected JSONArray parseFileAsArray(File reportFile) throws IOException, ParseException {
        JSONObject object;
        Object jsonObject;
        Object parsedJson = jsonParser.parse(Files.newBufferedReader(reportFile.toPath()));
        if (parsedJson instanceof JSONObject && (jsonObject = (object = (JSONObject)parsedJson).get("issues")) != null) {
            return (JSONArray)jsonObject;
        }
        if (parsedJson instanceof JSONArray) {
            JSONArray array = (JSONArray)parsedJson;
            return array;
        }
        String message = String.format("file is expected to contain a JSON array but didn't %s", reportFile.getPath());
        throw new ClassCastException(message);
    }

    @Override
    protected NewExternalIssue toExternalIssue(JSONObject issueJson) {
        RuleType type;
        Severity severity;
        Long effortInMinutes;
        ReportFormat reportFormat = ReportFormat.getFormatBasedOnReport(issueJson);
        String path = reportFormat.getPath(issueJson);
        InputFile inputFile = this.inputFile(path);
        String ruleId = reportFormat.getRuleId(issueJson);
        NewExternalIssue externalIssue = this.context.newExternalIssue();
        boolean loadPropertiesFromRepository = true;
        if (!HadolintRulesDefinition.RULE_LOADER.ruleKeys().contains(ruleId)) {
            if (ruleId.startsWith("DL") || ruleId.startsWith("SC")) {
                loadPropertiesFromRepository = false;
            } else {
                ruleId = "hadolint.fallback";
            }
        }
        externalIssue.ruleId(ruleId);
        if (loadPropertiesFromRepository) {
            effortInMinutes = HadolintRulesDefinition.RULE_LOADER.ruleConstantDebtMinutes(ruleId);
            severity = HadolintRulesDefinition.RULE_LOADER.ruleSeverity(ruleId);
            type = HadolintRulesDefinition.RULE_LOADER.ruleType(ruleId);
        } else {
            severity = Severity.valueOf(reportFormat.getSeverity(issueJson));
            type = RuleType.valueOf(reportFormat.getRuleType(issueJson));
            effortInMinutes = HadolintRulesDefinition.RULE_LOADER.ruleConstantDebtMinutes("hadolint.fallback");
        }
        externalIssue.ruleId(ruleId).engineId("hadolint").type(type).severity(severity).remediationEffortMinutes(effortInMinutes);
        NewIssueLocation issueLocation = reportFormat.getIssueLocation(issueJson, externalIssue, inputFile);
        return externalIssue.at(issueLocation);
    }
}

