/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.docker.checks.utils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.sonar.iac.docker.symbols.ArgumentResolution;
import org.sonar.iac.docker.tree.api.Argument;

public class Chmod {
    private static final Pattern CHMOD_OPTIONS_PATTERN = Pattern.compile("-[a-zA-Z]|--[a-zA-Z-]++");
    private static final String NUMERIC = "(?<numeric>[0-7]{1,4})";
    private static final String ALPHANUMERIC = "[ugoa]*+[=+-][rwxXstugo]++";
    private static final String ALPHANUMERICS = "(?<alphanumeric>(?:[ugoa]*+[=+-][rwxXstugo]++,?+)++)";
    private static final Pattern PERMISSIONS_PATTERN = Pattern.compile("(?<numeric>[0-7]{1,4})|(?<alphanumeric>(?:[ugoa]*+[=+-][rwxXstugo]++,?+)++)");
    public final Argument chmodArg;
    public final Argument permissionsArg;
    public final Permission permissions;

    public Chmod(@Nullable Argument chmodArg, @Nullable Argument permissionsArg, String permissions) {
        this.chmodArg = chmodArg;
        this.permissionsArg = permissionsArg;
        this.permissions = Chmod.parsePermissions(permissions);
    }

    private static Permission parsePermissions(String permissions) {
        Matcher matcher = PERMISSIONS_PATTERN.matcher(permissions);
        if (matcher.find()) {
            if (matcher.group("numeric") != null) {
                return Permission.fromNumeric(matcher.group("numeric"));
            }
            return Permission.fromAlphanumeric(matcher.group("alphanumeric"));
        }
        return Permission.empty();
    }

    public static List<Chmod> extractChmodsFromArguments(List<Argument> arguments) {
        ArrayList<Chmod> chmods = new ArrayList<Chmod>();
        List<String> argumentsStrings = arguments.stream().map(arg -> ArgumentResolution.of(arg).value()).toList();
        List<Integer> chmodIndexes = Chmod.findChmodIndexes(argumentsStrings);
        for (Integer chmodIndex : chmodIndexes) {
            Integer indexPermissions = Chmod.skipOptions(chmodIndex, argumentsStrings);
            if (indexPermissions == null) continue;
            chmods.add(new Chmod(arguments.get(chmodIndex), arguments.get(indexPermissions), argumentsStrings.get(indexPermissions)));
        }
        return chmods;
    }

    private static List<Integer> findChmodIndexes(List<String> arguments) {
        return IntStream.range(0, arguments.size()).filter(i -> "chmod".equals(arguments.get(i))).boxed().toList();
    }

    private static Integer skipOptions(int index, List<String> arguments) {
        while (++index < arguments.size() && arguments.get(index) != null && CHMOD_OPTIONS_PATTERN.matcher(arguments.get(index)).matches()) {
        }
        return index < arguments.size() ? Integer.valueOf(index) : null;
    }

    public boolean hasPermission(String right) {
        return this.permissions.rights.contains(right);
    }

    public static class Permission {
        Set<String> rights = new HashSet<String>();

        private Permission() {
        }

        static Permission empty() {
            return new Permission();
        }

        public static Permission fromAlphanumeric(String alphanumerics) {
            Permission chmodRight = new Permission();
            for (String alphanumeric : alphanumerics.split(",")) {
                if (alphanumeric.contains("-")) continue;
                String[] split = alphanumeric.split("[+=]");
                chmodRight.addRights(split[0], split[1]);
            }
            return chmodRight;
        }

        public static Permission fromNumeric(String numeric) {
            Permission chmodRight = new Permission();
            numeric = ("0000" + numeric).substring(numeric.length());
            chmodRight.addSet(numeric.charAt(0));
            chmodRight.addRight(numeric.charAt(1), 'u');
            chmodRight.addRight(numeric.charAt(2), 'g');
            chmodRight.addRight(numeric.charAt(3), 'o');
            return chmodRight;
        }

        private void addRight(char digit, char target) {
            int value = digit - 48;
            this.addIfFlag(target + "+r", value, 4);
            this.addIfFlag(target + "+w", value, 2);
            this.addIfFlag(target + "+x", value, 1);
        }

        private void addSet(char digit) {
            int value = digit - 48;
            this.addIfFlag("u+s", value, 4);
            this.addIfFlag("g+s", value, 2);
            this.addIfFlag("+t", value, 1);
        }

        private void addIfFlag(String right, int number, int flag) {
            if ((number & flag) > 0) {
                this.rights.add(right);
            }
        }

        private void addRights(String targets, String rights) {
            if (targets.isEmpty() || targets.equals("a")) {
                targets = "ugo";
            }
            for (char target : targets.toCharArray()) {
                for (char right : rights.toCharArray()) {
                    this.rights.add(target + "+" + right);
                }
            }
        }

        public boolean hasRight(String right) {
            return this.rights.contains(right);
        }
    }
}

