/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.docker.checks;

import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.IacCheck;
import org.sonar.iac.common.api.checks.InitContext;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.docker.checks.utils.ArgumentResolutionSplitter;
import org.sonar.iac.docker.checks.utils.CheckUtils;
import org.sonar.iac.docker.checks.utils.CommandDetector;
import org.sonar.iac.docker.checks.utils.StandardCommandDetectors;
import org.sonar.iac.docker.checks.utils.StringPredicate;
import org.sonar.iac.docker.symbols.ArgumentResolution;
import org.sonar.iac.docker.tree.api.DockerImage;
import org.sonar.iac.docker.tree.api.Flag;
import org.sonar.iac.docker.tree.api.RunInstruction;

@Rule(key="S6437")
public class SecretsGenerationCheck
implements IacCheck {
    private static final String MESSAGE = "Change this code not to store a secret in the image.";
    private static final String PASSWORD_FLAG = "--password";
    private static final String PASSWORD_FLAG_SHORT = "-p";
    private static final Set<String> SSH_KEYGEN_COMPLIANT_FLAGS = Set.of("-l", "-F", "-H", "-R", "-r", "-k", "-Q");
    private static final CommandDetector SSH_DETECTOR = CommandDetector.builder().with("ssh-keygen").withOptionalRepeatingExcept(SSH_KEYGEN_COMPLIANT_FLAGS).notWith(SSH_KEYGEN_COMPLIANT_FLAGS::contains).build();
    private static final Set<String> SENSITIVE_KEYTOOL_FLAGS = Set.of("-gencert", "-genkeypair", "-genseckey", "-genkey");
    private static final CommandDetector KEYTOOL_DETECTOR = CommandDetector.builder().with("keytool").withOptionalRepeating(arg -> !SENSITIVE_KEYTOOL_FLAGS.contains(arg)).with(SENSITIVE_KEYTOOL_FLAGS).withOptionalRepeating(arg -> true).build();
    private static final CommandDetector OPENSSL_GEN_DETECTOR = CommandDetector.builder().with("openssl").with(List.of("genrsa", "gendsa", "genpkey")).withOptionalRepeating(arg -> true).build();
    private static final Set<String> SENSITIVE_OPENSSL_REQ_OPTION = Set.of("-passout", "-passin", "-new", "-newkey", "-key", "-CAkey");
    private static final CommandDetector OPENSSL_REQ_DETECTOR = CommandDetector.builder().with("openssl").with("req").withOptionalRepeatingExcept(SENSITIVE_OPENSSL_REQ_OPTION).with(SENSITIVE_OPENSSL_REQ_OPTION).withOptionalRepeating(arg -> true).build();
    private static final Set<String> COMPLIANT_OPENSSL_RSA_OPTION = Set.of("-pubin", "-RSAPublicKey_in");
    private static final CommandDetector OPENSSL_RSA_DETECTOR = CommandDetector.builder().with("openssl").with("rsa").withAnyFlagExcept(COMPLIANT_OPENSSL_RSA_OPTION).build();
    private static final CommandDetector OPENSSL_EC_OR_PKEY_DETECTOR = CommandDetector.builder().with("openssl").with(List.of("ec", "pkey")).withAnyFlagExcept("-pubin").build();
    private static final CommandDetector OPENSSL_ECPARAMS_OR_DSAPARAM_DETECTOR = CommandDetector.builder().with("openssl").with(List.of("ecparams", "dsaparam")).withOptionalRepeatingExcept("-genkey").with("-genkey").withOptionalRepeating(arg -> true).build();
    private static final Set<String> SENSITIVE_OPENSSL_X509_OPTION = Set.of("-key", "-signkey", "-CAkey");
    private static final CommandDetector OPENSSL_X509_DETECTOR = CommandDetector.builder().with("openssl").with("x509").withOptionalRepeatingExcept(SENSITIVE_OPENSSL_X509_OPTION).with(SENSITIVE_OPENSSL_X509_OPTION).withOptionalRepeating(arg -> true).build();
    private static final CommandDetector X11VNC_STOREPASSWD_FLAG = CommandDetector.builder().with("x11vnc").withOptionalRepeatingExcept("-storepasswd").with("-storepasswd").withAnyIncludingUnresolvedRepeating(arg -> true).build();
    private static final CommandDetector WGET_PASSWORD_FLAG_EQUALS_PWD = StandardCommandDetectors.commandFlagEquals("wget", "--password");
    private static final CommandDetector WGET_PASSWORD_FLAG_SPACE_PWD = StandardCommandDetectors.commandFlagSpace("wget", "--password");
    private static final CommandDetector WGET_FTP_PASSWORD_FLAG_EQUALS_PWD = StandardCommandDetectors.commandFlagEquals("wget", "--ftp-password");
    private static final CommandDetector WGET_FTP_PASSWORD_FLAG_SPACE_PWD = StandardCommandDetectors.commandFlagSpace("wget", "--ftp-password");
    private static final CommandDetector WGET_HTTP_PASSWORD_FLAG_EQUALS_PWD = StandardCommandDetectors.commandFlagEquals("wget", "--http-password");
    private static final CommandDetector WGET_HTTP_PASSWORD_FLAG_SPACE_PWD = StandardCommandDetectors.commandFlagSpace("wget", "--http-password");
    private static final CommandDetector WGET_PROXY_PASSWORD_FLAG_EQUALS_PWD = StandardCommandDetectors.commandFlagEquals("wget", "--proxy-password");
    private static final CommandDetector WGET_PROXY_PASSWORD_FLAG_SPACE_PWD = StandardCommandDetectors.commandFlagSpace("wget", "--proxy-password");
    private static final CommandDetector CURL_USER_FLAG_SPACE_PWD = StandardCommandDetectors.commandFlagSpace("curl", "--user");
    private static final CommandDetector CURL_USER_SHORT_FLAG_SPACE_PWD = StandardCommandDetectors.commandFlagSpace("curl", "-u");
    private static final CommandDetector SSHPASS_P_FLAG_SPACE_PWD = StandardCommandDetectors.commandFlagSpace("sshpass", "-p");
    private static final CommandDetector SSHPASS_P_FLAG_NO_SPACE_PWD = StandardCommandDetectors.commandFlagNoSpace("sshpass", "-p");
    private static final List<String> MYSQL_COMMANDS = List.of("mysql", "mysqladmin", "mysqldump");
    private static final CommandDetector MYSQL_PASSWORD_EQUALS_PWD = StandardCommandDetectors.commandFlagEquals(MYSQL_COMMANDS, "--password");
    private static final CommandDetector MYSQL_P_FLAG_NO_SPACE_PWD = StandardCommandDetectors.commandFlagNoSpace(MYSQL_COMMANDS, "-p");
    private static final CommandDetector USERADD_PASSWORD_FLAG_SPACE_PWD = StandardCommandDetectors.commandFlagSpace("useradd", "--password");
    private static final CommandDetector USERADD_P_FLAG_SPACE_PWD = StandardCommandDetectors.commandFlagSpace("useradd", "-p");
    private static final CommandDetector USERMOD_PASSWORD_FLAG_SPACE_PWD = StandardCommandDetectors.commandFlagSpace("usermod", "--password");
    private static final CommandDetector USERMOD_P_FLAG_SPACE_PWD = StandardCommandDetectors.commandFlagSpace("usermod", "-p");
    private static final CommandDetector NET_USER_USERNAME_PASSWORD = CommandDetector.builder().with("net").with("user").withIncludeUnresolved(StringPredicate.startsWithIgnoreQuotes("/").negate()).withIncludeUnresolved(StringPredicate.startsWithIgnoreQuotes("/").or(StringPredicate.startsWithIgnoreQuotes("*")).negate()).build();
    private static final CommandDetector DRUSH_USER_PASSWORD = CommandDetector.builder().with("drush").withAnyFlag().with(StringPredicate.containsIgnoreQuotes(List.of("user:password", "upwd", "user-password"))).with(arg -> true).withIncludeUnresolved(arg -> true).build();
    private static final CommandDetector DRUSH_PASSWORD_FLAG_EQUALS_PWD = StandardCommandDetectors.commandFlagEquals("drush", "--password");
    private static final Set<CommandDetector> DETECTORS_THAT_STORE_SECRETS = Set.of(SSH_DETECTOR, KEYTOOL_DETECTOR, OPENSSL_GEN_DETECTOR, OPENSSL_REQ_DETECTOR, OPENSSL_RSA_DETECTOR, OPENSSL_EC_OR_PKEY_DETECTOR, OPENSSL_ECPARAMS_OR_DSAPARAM_DETECTOR, OPENSSL_X509_DETECTOR, X11VNC_STOREPASSWD_FLAG);
    private static final Set<CommandDetector> DETECTORS_THAT_HAVE_SECRETS_IN_CMD = Set.of(WGET_PASSWORD_FLAG_EQUALS_PWD, WGET_PASSWORD_FLAG_SPACE_PWD, WGET_FTP_PASSWORD_FLAG_EQUALS_PWD, WGET_FTP_PASSWORD_FLAG_SPACE_PWD, WGET_HTTP_PASSWORD_FLAG_EQUALS_PWD, WGET_HTTP_PASSWORD_FLAG_SPACE_PWD, WGET_PROXY_PASSWORD_FLAG_EQUALS_PWD, WGET_PROXY_PASSWORD_FLAG_SPACE_PWD, SSHPASS_P_FLAG_NO_SPACE_PWD, SSHPASS_P_FLAG_SPACE_PWD, MYSQL_PASSWORD_EQUALS_PWD, MYSQL_P_FLAG_NO_SPACE_PWD, USERADD_PASSWORD_FLAG_SPACE_PWD, USERADD_P_FLAG_SPACE_PWD, USERMOD_PASSWORD_FLAG_SPACE_PWD, USERMOD_P_FLAG_SPACE_PWD, NET_USER_USERNAME_PASSWORD, DRUSH_USER_PASSWORD, DRUSH_PASSWORD_FLAG_EQUALS_PWD);
    private static final Set<CommandDetector> CURL_DETECTORS = Set.of(CURL_USER_FLAG_SPACE_PWD, CURL_USER_SHORT_FLAG_SPACE_PWD);

    @Override
    public void initialize(InitContext init) {
        init.register(DockerImage.class, SecretsGenerationCheck::checkDockerImage);
    }

    private static void checkDockerImage(CheckContext ctx, DockerImage dockerImage) {
        if (!dockerImage.isLastDockerImageInFile()) {
            return;
        }
        dockerImage.instructions().stream().filter(RunInstruction.class::isInstance).map(RunInstruction.class::cast).forEach(runInstruction -> SecretsGenerationCheck.checkRunInstruction(ctx, runInstruction));
    }

    private static void checkRunInstruction(CheckContext ctx, RunInstruction runInstruction) {
        List<ArgumentResolution> resolvedArgument = CheckUtils.resolveInstructionArguments(runInstruction);
        DETECTORS_THAT_STORE_SECRETS.forEach(detector -> detector.search(resolvedArgument).forEach(command -> ctx.reportIssue((HasTextRange)command, MESSAGE)));
        if (SecretsGenerationCheck.isMountSecret(runInstruction)) {
            return;
        }
        DETECTORS_THAT_HAVE_SECRETS_IN_CMD.forEach(detector -> detector.search(resolvedArgument).forEach(command -> ctx.reportIssue((HasTextRange)command, MESSAGE)));
        CURL_DETECTORS.forEach(detector -> detector.search(resolvedArgument).forEach(command -> {
            ArgumentResolution userAndPassword = SecretsGenerationCheck.getLastArgument(command);
            if (userAndPassword.value().contains(":")) {
                ctx.reportIssue((HasTextRange)command, MESSAGE);
            }
        }));
        ArgumentResolutionSplitter.splitCommands(resolvedArgument).elements().forEach(arguments -> SecretsGenerationCheck.checkHtpasswd(arguments, ctx));
    }

    private static boolean isMountSecret(RunInstruction runInstruction) {
        for (Flag option : runInstruction.options()) {
            if (!"mount".equals(option.name()) || !ArgumentResolution.of(option.value()).value().contains("type=secret")) continue;
            return true;
        }
        return false;
    }

    private static void checkHtpasswd(List<ArgumentResolution> resolvedArgument, CheckContext ctx) {
        if (HtpasswdDetector.detectSensitiveCommand(resolvedArgument)) {
            ctx.reportIssue(new CommandDetector.Command(resolvedArgument), MESSAGE);
        }
    }

    private static ArgumentResolution getLastArgument(CommandDetector.Command command) {
        List<ArgumentResolution> arguments = command.getResolvedArguments();
        return arguments.get(arguments.size() - 1);
    }

    private static final class HtpasswdDetector {
        private HtpasswdDetector() {
        }

        public static boolean detectSensitiveCommand(List<ArgumentResolution> resolvedArgument) {
            boolean flagB = false;
            boolean flagN = false;
            int numberOfNonFlags = 0;
            for (int i = 0; i < resolvedArgument.size(); ++i) {
                String current = resolvedArgument.get(i).value();
                if (i == 0 && !"htpasswd".equals(current)) break;
                if (current.startsWith("-")) {
                    if (current.contains("b")) {
                        flagB = true;
                    }
                    if (!current.contains("n")) continue;
                    flagN = true;
                    continue;
                }
                ++numberOfNonFlags;
            }
            return HtpasswdDetector.isSensitive(flagB, flagN, numberOfNonFlags);
        }

        private static boolean isSensitive(boolean flagB, boolean flagN, int numberOfNonFlags) {
            return flagB && (HtpasswdDetector.notFlagNAnd4NonFlags(flagN, numberOfNonFlags) || HtpasswdDetector.flagNAnd3NonFlags(flagN, numberOfNonFlags));
        }

        private static boolean flagNAnd3NonFlags(boolean flagN, int numberOfNonFlags) {
            return flagN && numberOfNonFlags == 3;
        }

        private static boolean notFlagNAnd4NonFlags(boolean flagN, int numberOfNonFlags) {
            return !flagN && numberOfNonFlags == 4;
        }
    }
}

