/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.docker.checks;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.IacCheck;
import org.sonar.iac.common.api.checks.InitContext;
import org.sonar.iac.docker.checks.utils.CheckUtils;
import org.sonar.iac.docker.checks.utils.CommandDetector;
import org.sonar.iac.docker.symbols.ArgumentResolution;
import org.sonar.iac.docker.tree.api.RunInstruction;

@Rule(key="S6584")
public class PackageManagerConsentFlagCheck
implements IacCheck {
    private static final String MESSAGE = "Add consent flag so that this command doesn't require user confirmation.";
    private static final String ASSUME_YES_FLAG = "--assume-yes";
    private static final Map<String, CommandOption> MANAGERS_TO_CONSENT_FLAGS = Map.of("apt-get", new CommandOption("-y", List.of("--yes", "--assume-yes")), "apt", new CommandOption("-y", List.of("--yes", "--assume-yes")), "aptitude", new CommandOption("-y", List.of("--assume-yes")));
    private static final Set<String> APT_COMMANDS_REQUIRING_CONFIRMATION = Set.of("upgrade", "dist-upgrade", "install", "reinstall", "remove", "purge");
    private static final CommandDetector DEBIAN_PACKAGE_MANAGER_DETECTOR = CommandDetector.builder().with(Set.of("apt", "apt-get", "aptitude")).withAnyFlag().with(APT_COMMANDS_REQUIRING_CONFIRMATION).withOptionalRepeating(s -> true).build();

    @Override
    public void initialize(InitContext init) {
        init.register(RunInstruction.class, PackageManagerConsentFlagCheck::checkRunInstruction);
    }

    private static void checkRunInstruction(CheckContext ctx, RunInstruction runInstruction) {
        List<ArgumentResolution> argumentResolutions = CheckUtils.resolveInstructionArguments(runInstruction);
        DEBIAN_PACKAGE_MANAGER_DETECTOR.search(argumentResolutions).forEach(c -> {
            if (PackageManagerConsentFlagCheck.isPackageManagerInvocationWithoutConsent(c)) {
                ctx.reportIssue(c.textRange(), MESSAGE);
            }
        });
    }

    private static boolean isPackageManagerInvocationWithoutConsent(CommandDetector.Command command) {
        String commandName = command.getResolvedArguments().get(0).value();
        return command.getResolvedArguments().stream().noneMatch(argumentResolution -> MANAGERS_TO_CONSENT_FLAGS.get(commandName).matches(argumentResolution.value()));
    }

    static class CommandOption {
        private final String shortVariant;
        private final List<String> longVariants;

        CommandOption(String shortVariant, List<String> longVariants) {
            this.shortVariant = shortVariant;
            this.longVariants = longVariants;
        }

        boolean matches(String flag) {
            if (flag.startsWith("--")) {
                for (String longVariant : this.longVariants) {
                    if (!longVariant.equals(flag)) continue;
                    return true;
                }
                return false;
            }
            return flag.startsWith("-") && flag.indexOf(this.shortVariant.charAt(1)) != -1;
        }
    }
}

