/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.docker.checks;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.sonar.check.Rule;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.IacCheck;
import org.sonar.iac.common.api.checks.InitContext;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.docker.checks.utils.CheckUtils;
import org.sonar.iac.docker.checks.utils.CommandDetector;
import org.sonar.iac.docker.checks.utils.StringPredicate;
import org.sonar.iac.docker.symbols.ArgumentResolution;
import org.sonar.iac.docker.tree.api.RunInstruction;

@Rule(key="S6506")
public class ClearTextProtocolDowngradeCheck
implements IacCheck {
    private static final String CURL_MESSAGE = "Not enforcing HTTPS here might allow for redirections to insecure websites. Make sure it is safe here.";
    private static final String WGET_MESSAGE = "Not disabling redirects might allow for redirections to insecure websites. Make sure it is safe here.";
    private static final String CURL_COMMAND = "curl";
    private static final String PROTO_FLAG = "--proto";
    private static final Set<String> WGET_NO_REDIRECT_FLAGS = Set.of("--max-redirect=0", "--max-redirect='0'", "--max-redirect=\"0\"");
    private static final Set<String> REDIRECTION_FLAGS = Set.of("-L", "--location");
    private static final Set<String> SENSITIVE_FLAGS = Set.of("-L", "--location", "--proto");
    private static final String REDIRECTION_SHORT_FLAG = "L";
    private static final Predicate<String> EQUALS_PROTO_FLAG_OPTION = StringPredicate.equalsIgnoreQuotes("=https");
    private static final Predicate<String> SENSITIVE_HTTPS_URL_BEGINNING = StringPredicate.startsWithIgnoreQuotes("https");
    private static final Predicate<String> SHORT_FLAG = s -> s.startsWith("-") && (s.length() == 1 || s.charAt(1) != '-');
    private static final Predicate<String> LONG_FLAG = s -> s.startsWith("--");
    private static final Predicate<String> LONG_OTHER_FLAG = LONG_FLAG.and(Predicate.not(ClearTextProtocolDowngradeCheck.longFlagContainingOneOf(SENSITIVE_FLAGS)));
    private static final Predicate<String> SHORT_OTHER_FLAG = SHORT_FLAG.and(Predicate.not(ClearTextProtocolDowngradeCheck.shortFlagContaining("L")));
    private static final Predicate<String> OPTIONAL_OTHER_FLAGS = LONG_OTHER_FLAG.or(SHORT_OTHER_FLAG);
    private static final CommandDetector.Builder REDIRECTION_PREDICATES = CommandDetector.builder().withOptionalRepeating(OPTIONAL_OTHER_FLAGS).with(ClearTextProtocolDowngradeCheck.longFlagContainingOneOf(REDIRECTION_FLAGS).or(ClearTextProtocolDowngradeCheck.shortFlagContaining("L"))).withOptionalRepeating(OPTIONAL_OTHER_FLAGS);
    private static final CommandDetector.Builder PROTO_FLAG_MISSING_OPTION_PREDICATES = CommandDetector.builder().withOptionalRepeating(OPTIONAL_OTHER_FLAGS).with("--proto").notWith(EQUALS_PROTO_FLAG_OPTION).withOptionalRepeating(OPTIONAL_OTHER_FLAGS);
    private static final CommandDetector.Builder PROTO_FLAG_MISSING_PREDICATES = CommandDetector.builder().withOptionalRepeating(OPTIONAL_OTHER_FLAGS).notWith("--proto"::equals).withOptionalRepeating(OPTIONAL_OTHER_FLAGS);
    private static final CommandDetector.Builder PROTO_FLAG_WITH_WRONG_OPTION_PREDICATES = CommandDetector.builder().withOptionalRepeating(OPTIONAL_OTHER_FLAGS).with("--proto").with(Predicate.not(EQUALS_PROTO_FLAG_OPTION)).withOptionalRepeating(OPTIONAL_OTHER_FLAGS);
    private static final CommandDetector SENSITIVE_CURL_COMMAND_FLAG_WITH_MISSING_OPTION = CommandDetector.builder().with("curl").withPredicatesFrom(REDIRECTION_PREDICATES).withPredicatesFrom(PROTO_FLAG_MISSING_OPTION_PREDICATES).with(SENSITIVE_HTTPS_URL_BEGINNING).build();
    private static final CommandDetector SENSITIVE_CURL_COMMAND_FLAG_WITH_MISSING_OPTION_DIFF_ORDER = CommandDetector.builder().with("curl").withPredicatesFrom(PROTO_FLAG_MISSING_OPTION_PREDICATES).withPredicatesFrom(REDIRECTION_PREDICATES).with(SENSITIVE_HTTPS_URL_BEGINNING).build();
    private static final CommandDetector SENSITIVE_CURL_COMMAND_MISSING_FLAG = CommandDetector.builder().with("curl").withPredicatesFrom(REDIRECTION_PREDICATES).withPredicatesFrom(PROTO_FLAG_MISSING_PREDICATES).with(SENSITIVE_HTTPS_URL_BEGINNING).build();
    private static final CommandDetector SENSITIVE_CURL_COMMAND_FLAG_WITH_WRONG_OPTION = CommandDetector.builder().with("curl").withPredicatesFrom(REDIRECTION_PREDICATES).withPredicatesFrom(PROTO_FLAG_WITH_WRONG_OPTION_PREDICATES).with(SENSITIVE_HTTPS_URL_BEGINNING).build();
    private static final CommandDetector SENSITIVE_CURL_COMMAND_FLAG_WITH_WRONG_OPTION_DIFF_ORDER = CommandDetector.builder().with("curl").withPredicatesFrom(PROTO_FLAG_WITH_WRONG_OPTION_PREDICATES).withPredicatesFrom(REDIRECTION_PREDICATES).with(SENSITIVE_HTTPS_URL_BEGINNING).build();
    private static final CommandDetector WGET_DETECTOR = CommandDetector.builder().with("wget").withAnyFlagExcept(WGET_NO_REDIRECT_FLAGS).with(SENSITIVE_HTTPS_URL_BEGINNING).withAnyFlagExcept(WGET_NO_REDIRECT_FLAGS).build();
    private static final Set<CommandDetector> SENSITIVE_CURL_COMMAND_DETECTORS = Set.of(SENSITIVE_CURL_COMMAND_FLAG_WITH_MISSING_OPTION, SENSITIVE_CURL_COMMAND_FLAG_WITH_MISSING_OPTION_DIFF_ORDER, SENSITIVE_CURL_COMMAND_MISSING_FLAG, SENSITIVE_CURL_COMMAND_FLAG_WITH_WRONG_OPTION, SENSITIVE_CURL_COMMAND_FLAG_WITH_WRONG_OPTION_DIFF_ORDER);

    @Override
    public void initialize(InitContext init) {
        init.register(RunInstruction.class, ClearTextProtocolDowngradeCheck::checkRunInstruction);
    }

    private static void checkRunInstruction(CheckContext ctx, RunInstruction runInstruction) {
        List<ArgumentResolution> resolvedArgument = CheckUtils.resolveInstructionArguments(runInstruction);
        SENSITIVE_CURL_COMMAND_DETECTORS.forEach(commandDetector -> commandDetector.search(resolvedArgument).forEach(command -> ctx.reportIssue((HasTextRange)command, CURL_MESSAGE)));
        WGET_DETECTOR.search(resolvedArgument).forEach(command -> ctx.reportIssue((HasTextRange)command, WGET_MESSAGE));
    }

    private static Predicate<String> longFlagContainingOneOf(Collection<String> flags) {
        return LONG_FLAG.and(flags::contains);
    }

    private static Predicate<String> shortFlagContaining(String flag) {
        return SHORT_FLAG.and(s -> s.contains(flag));
    }
}

