/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.common.yaml.tree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.snakeyaml.engine.v2.comments.CommentLine;
import org.snakeyaml.engine.v2.exceptions.Mark;
import org.snakeyaml.engine.v2.nodes.Node;
import org.sonar.iac.common.api.tree.Comment;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.common.api.tree.impl.CommentImpl;
import org.sonar.iac.common.api.tree.impl.TextRange;
import org.sonar.iac.common.api.tree.impl.TextRanges;
import org.sonar.iac.common.extension.ParseException;

public record YamlTreeMetadata(String tag, TextRange textRange, int startPointer, int endPointer, List<Comment> comments) implements HasTextRange
{
    @Deprecated
    public static YamlTreeMetadata fromNode(String tag, Node node) {
        return YamlTreeMetadata.builder().fromNode(node).withTag(tag).build();
    }

    @Deprecated
    public static YamlTreeMetadata fromNode(Node node) {
        return YamlTreeMetadata.builder().fromNode(node).build();
    }

    @Deprecated
    public static YamlTreeMetadata fromNodes(String tag, Node firstNode, Node secondNode) {
        return YamlTreeMetadata.builder().fromNodes(firstNode, secondNode).withTag(tag).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Node startNode;
        private Node endNode;
        private String tag;
        private List<Comment> comments;

        public Builder fromNode(Node node) {
            this.startNode = node;
            this.endNode = node;
            return this;
        }

        public Builder fromNodes(Node startNode, Node endNode) {
            this.startNode = startNode;
            this.endNode = endNode;
            return this;
        }

        public Builder withTag(String tag) {
            this.tag = tag;
            return this;
        }

        public Builder withComments(List<CommentLine> commentLines) {
            this.comments = Builder.comments(commentLines);
            return this;
        }

        public YamlTreeMetadata build() {
            int startPointer;
            if (this.tag == null) {
                this.tag = Builder.tag(this.startNode);
            }
            if (this.comments == null) {
                this.comments = Builder.comments(this.startNode);
            }
            TextRange range = TextRanges.merge(Builder.range(this.startNode), Builder.range(this.endNode));
            int endPointer = startPointer = Builder.pointer(this.startNode.getStartMark().orElse(null));
            if (this.endNode.getEndMark().isPresent()) {
                endPointer = Builder.pointer(this.endNode.getEndMark().orElse(null));
            }
            return new YamlTreeMetadata(this.tag, range, startPointer, endPointer, this.comments);
        }

        public static String tag(Node node) {
            return node.getTag().getValue();
        }

        private static int pointer(@Nullable Mark mark) {
            if (mark == null) {
                throw new ParseException("Nodes are expected to have a start mark during conversion", null, null);
            }
            return mark.getPointer();
        }

        public static TextRange range(Node node) {
            return Builder.range(node.getStartMark().orElse(null), node.getEndMark().orElse(null));
        }

        private static TextRange range(@Nullable Mark startMark, @Nullable Mark endMark) {
            if (startMark == null) {
                throw new ParseException("Nodes are expected to have a start mark during conversion", null, null);
            }
            int startLine = startMark.getLine() + 1;
            int startColumn = startMark.getColumn();
            if (endMark != null) {
                return TextRanges.range(startLine, startColumn, endMark.getLine() + 1, endMark.getColumn());
            }
            return TextRanges.range(startLine, startColumn, startLine, startColumn);
        }

        public static List<Comment> comments(Node node) {
            ArrayList<Comment> comments = new ArrayList<Comment>(Builder.comments(node.getBlockComments()));
            comments.addAll(Builder.comments(node.getInLineComments()));
            comments.addAll(Builder.comments(node.getEndComments()));
            return comments;
        }

        private static List<Comment> comments(@Nullable List<CommentLine> commentLines) {
            if (commentLines == null) {
                return Collections.emptyList();
            }
            ArrayList<Comment> comments = new ArrayList<Comment>();
            for (CommentLine comment : commentLines) {
                comments.add(Builder.comment(comment));
            }
            return comments;
        }

        private static Comment comment(CommentLine comment) {
            TextRange ranage = Builder.range(comment.getStartMark().orElse(null), comment.getEndMark().orElse(null));
            return new CommentImpl("#" + comment.getValue(), comment.getValue(), ranage);
        }
    }
}

