/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.common.yaml;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.checks.TextUtils;
import org.sonar.iac.common.yaml.tree.ScalarTree;
import org.sonar.iac.common.yaml.tree.ScalarTreeImpl;
import org.sonar.iac.common.yaml.tree.SequenceTree;
import org.sonar.iac.common.yaml.tree.SequenceTreeImpl;
import org.sonar.iac.common.yaml.tree.YamlTree;
import org.sonar.iac.common.yaml.tree.YamlTreeMetadata;

public final class YamlTreeUtils {
    private static final YamlTreeMetadata METADATA = new YamlTreeMetadata(null, null, 0, 0, Collections.emptyList());
    private static final ScalarTree.Style STYLE = ScalarTree.Style.PLAIN;

    private YamlTreeUtils() {
    }

    public static List<String> getListValueElements(@Nullable Tree tree) {
        if (tree instanceof ScalarTree) {
            ScalarTree scalarTree = (ScalarTree)tree;
            return List.of(TextUtils.getValue(scalarTree).orElse(""));
        }
        if (tree instanceof SequenceTree) {
            SequenceTree sequenceTree = (SequenceTree)tree;
            return YamlTreeUtils.getValuesOfSequenceTree(sequenceTree);
        }
        return Collections.emptyList();
    }

    private static List<String> getValuesOfSequenceTree(SequenceTree tree) {
        return tree.elements().stream().map(YamlTreeUtils::getListValueElements).flatMap(Collection::stream).toList();
    }

    public static YamlTree scalar(String value) {
        return new ScalarTreeImpl(value, STYLE, METADATA);
    }

    public static YamlTree sequence(String ... values) {
        List<YamlTree> elements = Arrays.stream(values).map(v -> new ScalarTreeImpl((String)v, STYLE, METADATA)).collect(Collectors.toList());
        return new SequenceTreeImpl(elements, METADATA);
    }
}

