/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.cloudformation.checks;

import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.iac.cloudformation.checks.AbstractResourceCheck;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.checks.PropertyUtils;
import org.sonar.iac.common.checks.TextUtils;
import org.sonar.iac.common.yaml.tree.YamlTree;

@Rule(key="S6252")
public class UnversionedS3BucketCheck
extends AbstractResourceCheck {
    private static final String MESSAGE = "Make sure using %s S3 bucket is safe here.";
    private static final String OMITTING_MESSAGE = "Omitting \"VersioningConfiguration\" disables S3 bucket versioning. Make sure it is safe here.";
    private static final String UNVERSIONED_MSG = "unversioned";
    private static final String SUSPENDED_MSG = "suspended versioned";
    private static final String SECONDARY_MSG = "Related bucket";
    private static final String SUSPENDED_VALUE = "Suspended";

    @Override
    protected void checkResource(CheckContext ctx, AbstractResourceCheck.Resource resource) {
        if (UnversionedS3BucketCheck.isS3Bucket(resource)) {
            this.checkVersioning(ctx, resource);
        }
    }

    protected void checkVersioning(CheckContext ctx, AbstractResourceCheck.Resource resource) {
        YamlTree properties = resource.properties();
        Optional<Tree> versioning = PropertyUtils.value((Tree)properties, "VersioningConfiguration");
        if (versioning.isPresent()) {
            Optional<Tree> status = PropertyUtils.value(versioning.get(), "Status");
            if (status.isPresent()) {
                TextUtils.getValue(status.get()).filter(SUSPENDED_VALUE::equals).ifPresent(s -> ctx.reportIssue((HasTextRange)status.get(), String.format(MESSAGE, SUSPENDED_MSG), new SecondaryLocation(resource.type(), SECONDARY_MSG)));
            } else if (properties != null) {
                ctx.reportIssue((HasTextRange)UnversionedS3BucketCheck.versioningKey(properties), String.format(MESSAGE, UNVERSIONED_MSG), new SecondaryLocation(resource.type(), SECONDARY_MSG));
            }
        } else {
            ctx.reportIssue(resource.type(), OMITTING_MESSAGE);
        }
    }

    private static Tree versioningKey(YamlTree properties) {
        return PropertyUtils.key(properties, "VersioningConfiguration").orElse(properties);
    }
}

