/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.cloudformation.checks;

import org.sonar.check.Rule;
import org.sonar.iac.cloudformation.checks.AbstractResourceCheck;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.checks.PropertyUtils;
import org.sonar.iac.common.checks.TextUtils;

@Rule(key="S6330")
public class UnencryptedSqsQueueCheck
extends AbstractResourceCheck {
    private static final String MESSAGE = "Setting \"SqsManagedSseEnabled\" to \"false\" disables SQS queues encryption. Make sure it is safe here.";

    @Override
    protected void checkResource(CheckContext ctx, AbstractResourceCheck.Resource resource) {
        if (resource.isType("AWS::SQS::Queue")) {
            if (PropertyUtils.has(resource.properties(), "KmsMasterKeyId").isTrue()) {
                return;
            }
            PropertyUtils.get((Tree)resource.properties(), "SqsManagedSseEnabled").filter(property -> TextUtils.isValueFalse(property.value())).ifPresent(property -> ctx.reportIssue((HasTextRange)property, MESSAGE));
        }
    }
}

