/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.arm.tree.impl.json;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.sonar.iac.arm.tree.api.ArmTree;
import org.sonar.iac.arm.tree.api.Expression;
import org.sonar.iac.arm.tree.api.Identifier;
import org.sonar.iac.arm.tree.api.Property;
import org.sonar.iac.arm.tree.api.ResourceDeclaration;
import org.sonar.iac.arm.tree.api.StringLiteral;
import org.sonar.iac.arm.tree.api.bicep.SyntaxToken;
import org.sonar.iac.arm.tree.impl.AbstractArmTreeImpl;
import org.sonar.iac.common.api.tree.TextTree;
import org.sonar.iac.common.api.tree.Tree;

public class ResourceDeclarationImpl
extends AbstractArmTreeImpl
implements ResourceDeclaration {
    private static final Set<String> IGNORED_CHILDREN_RESOURCE_PROPERTIES = Set.of("type", "apiversion", "name", "resources");
    private final Expression name;
    private final Expression version;
    private final StringLiteral type;
    private final List<Property> properties;
    private final List<Property> resourceProperties;
    private final List<ResourceDeclaration> childResources;

    public ResourceDeclarationImpl(Expression name, Expression version, StringLiteral type, List<Property> properties, List<Property> resourceProperties, List<ResourceDeclaration> childResources) {
        this.name = name;
        this.version = version;
        this.type = type;
        this.properties = properties;
        this.resourceProperties = resourceProperties;
        this.childResources = childResources;
    }

    @Override
    public List<Tree> children() {
        ArrayList<Tree> children = new ArrayList<Tree>();
        children.add(this.name);
        children.add(this.version);
        children.add(this.type);
        this.resourceProperties.forEach(property -> {
            TextTree propertyKey = property.key();
            if (!IGNORED_CHILDREN_RESOURCE_PROPERTIES.contains(propertyKey.value().toLowerCase(Locale.ROOT))) {
                children.add(propertyKey);
                children.add(property.value());
            }
        });
        children.addAll(this.childResources);
        return children;
    }

    @Override
    @CheckForNull
    public Expression name() {
        return this.name;
    }

    @Override
    @CheckForNull
    public Identifier symbolicName() {
        return null;
    }

    @Override
    @CheckForNull
    public SyntaxToken existing() {
        return null;
    }

    @Override
    public Expression version() {
        return this.version;
    }

    @Override
    public TextTree type() {
        return this.type;
    }

    @Override
    public List<Property> properties() {
        return this.properties;
    }

    @Override
    public List<Property> resourceProperties() {
        return this.resourceProperties;
    }

    @Override
    public List<ResourceDeclaration> childResources() {
        return this.childResources;
    }

    @Override
    public ArmTree.Kind getKind() {
        return ArmTree.Kind.RESOURCE_DECLARATION;
    }
}

