/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.arm.tree.impl.json;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.iac.arm.symbols.Symbol;
import org.sonar.iac.arm.tree.ArmHelper;
import org.sonar.iac.arm.tree.api.ArrayExpression;
import org.sonar.iac.arm.tree.api.Expression;
import org.sonar.iac.arm.tree.api.Identifier;
import org.sonar.iac.arm.tree.api.NumericLiteral;
import org.sonar.iac.arm.tree.api.ParameterDeclaration;
import org.sonar.iac.arm.tree.api.ParameterType;
import org.sonar.iac.arm.tree.api.StringLiteral;
import org.sonar.iac.arm.tree.impl.AbstractArmTreeImpl;
import org.sonar.iac.common.api.tree.TextTree;
import org.sonar.iac.common.api.tree.Tree;

public class ParameterDeclarationImpl
extends AbstractArmTreeImpl
implements ParameterDeclaration {
    private final Identifier identifier;
    private final StringLiteral type;
    private final Expression defaultValue;
    private final ArrayExpression allowedValues;
    private final StringLiteral description;
    private final NumericLiteral minValue;
    private final NumericLiteral maxValue;
    private final NumericLiteral minLength;
    private final NumericLiteral maxLength;
    private Symbol symbol;

    public ParameterDeclarationImpl(Identifier identifier, @Nullable StringLiteral type, @Nullable Expression defaultValue, @Nullable ArrayExpression allowedValues, @Nullable StringLiteral description, @Nullable NumericLiteral minValue, @Nullable NumericLiteral maxValue, @Nullable NumericLiteral minLength, @Nullable NumericLiteral maxLength) {
        this.identifier = identifier;
        this.type = type;
        this.defaultValue = defaultValue;
        this.allowedValues = allowedValues;
        this.description = description;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.minLength = minLength;
        this.maxLength = maxLength;
    }

    @Override
    public List<Tree> children() {
        ArrayList<Tree> children = new ArrayList<Tree>();
        children.add(this.identifier);
        ArmHelper.addChildrenIfPresent(children, this.type);
        ArmHelper.addChildrenIfPresent(children, this.defaultValue);
        ArmHelper.addChildrenIfPresent(children, this.description);
        ArmHelper.addChildrenIfPresent(children, this.minValue);
        ArmHelper.addChildrenIfPresent(children, this.maxValue);
        ArmHelper.addChildrenIfPresent(children, this.minLength);
        ArmHelper.addChildrenIfPresent(children, this.maxLength);
        ArmHelper.addChildrenIfPresent(children, this.allowedValues);
        return children;
    }

    @Override
    public Identifier declaratedName() {
        return this.identifier;
    }

    @Override
    @CheckForNull
    public ParameterType type() {
        if (this.type != null) {
            return ParameterType.fromName(this.type.value());
        }
        return null;
    }

    @Override
    @CheckForNull
    public TextTree resourceType() {
        return null;
    }

    @Override
    @CheckForNull
    public Expression defaultValue() {
        return this.defaultValue;
    }

    @Override
    public List<Expression> allowedValues() {
        return Optional.ofNullable(this.allowedValues).map(ArrayExpression::elements).orElse(Collections.emptyList());
    }

    @Override
    @CheckForNull
    public StringLiteral description() {
        return this.description;
    }

    @Override
    @CheckForNull
    public NumericLiteral minValue() {
        return this.minValue;
    }

    @Override
    @CheckForNull
    public NumericLiteral maxValue() {
        return this.maxValue;
    }

    @Override
    @CheckForNull
    public NumericLiteral minLength() {
        return this.minLength;
    }

    @Override
    @CheckForNull
    public NumericLiteral maxLength() {
        return this.maxLength;
    }

    @Override
    @Nullable
    public Symbol symbol() {
        return this.symbol;
    }

    @Override
    public void setSymbol(Symbol symbol) {
        if (this.symbol != null) {
            throw new IllegalArgumentException("A symbol is already set");
        }
        this.symbol = symbol;
    }
}

