/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.arm.tree.impl.bicep;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.iac.arm.symbols.SymbolTable;
import org.sonar.iac.arm.tree.api.ArmTree;
import org.sonar.iac.arm.tree.api.Expression;
import org.sonar.iac.arm.tree.api.File;
import org.sonar.iac.arm.tree.api.Statement;
import org.sonar.iac.arm.tree.api.bicep.SyntaxToken;
import org.sonar.iac.arm.tree.api.bicep.TargetScopeDeclaration;
import org.sonar.iac.arm.tree.impl.AbstractArmTreeImpl;
import org.sonar.iac.common.api.tree.Tree;

public class FileImpl
extends AbstractArmTreeImpl
implements File {
    private final List<Statement> statements;
    private final SyntaxToken eof;
    private SymbolTable symbolTable;

    public FileImpl(List<Statement> statements, SyntaxToken eof) {
        this.statements = statements;
        this.eof = eof;
    }

    @Override
    public List<Tree> children() {
        ArrayList<Tree> trees = new ArrayList<Tree>(this.statements);
        trees.add((Statement)((Object)this.eof));
        return trees;
    }

    @Override
    public ArmTree.Kind getKind() {
        return ArmTree.Kind.FILE;
    }

    @Override
    public File.Scope targetScope() {
        return this.findDeclarationStatement().map(TargetScopeDeclaration::scope).orElse(File.Scope.RESOURCE_GROUP);
    }

    @Override
    @CheckForNull
    public Expression targetScopeLiteral() {
        return this.findDeclarationStatement().map(TargetScopeDeclaration::value).orElse(null);
    }

    @Override
    public List<Statement> statements() {
        return this.statements;
    }

    private Optional<TargetScopeDeclaration> findDeclarationStatement() {
        return this.statements.stream().filter(s -> s.is(ArmTree.Kind.TARGET_SCOPE_DECLARATION)).findFirst().map(d -> (TargetScopeDeclaration)d);
    }

    @Override
    @Nullable
    public SymbolTable symbolTable() {
        return this.symbolTable;
    }

    @Override
    public void setSymbolTable(SymbolTable symbolTable) {
        if (this.symbolTable != null) {
            throw new IllegalArgumentException("A symbolTable is already set");
        }
        this.symbolTable = symbolTable;
    }
}

