/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.arm.symbols;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.iac.arm.symbols.Symbol;
import org.sonar.iac.arm.tree.api.HasIdentifier;

public class SymbolTable {
    private final Map<String, Symbol> symbols = new HashMap<String, Symbol>();
    private final Set<HasIdentifier> unresolvedReferences = new HashSet<HasIdentifier>();

    public Symbol addSymbol(String name) {
        return this.symbols.computeIfAbsent(name, s -> new Symbol(this, name));
    }

    @Nullable
    public Symbol getSymbol(String name) {
        return this.symbols.getOrDefault(name, null);
    }

    public List<Symbol> getSymbols() {
        return new ArrayList<Symbol>(this.symbols.values());
    }

    public void foundUnresolvableSymbolAccess(HasIdentifier hasIdentifier) {
        this.unresolvedReferences.add(hasIdentifier);
    }

    public Set<HasIdentifier> getUnresolvedReferences() {
        return this.unresolvedReferences;
    }

    public boolean hasFoundUnresolvableSymbolAccess() {
        return !this.unresolvedReferences.isEmpty();
    }
}

