/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.arm.symbols;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import org.sonar.iac.arm.symbols.SymbolTable;
import org.sonar.iac.arm.symbols.Usage;
import org.sonar.iac.arm.tree.api.ArmTree;
import org.sonar.iac.arm.tree.api.HasSymbol;
import org.sonar.iac.arm.tree.api.bicep.Declaration;

public class Symbol {
    private final SymbolTable symbolTable;
    private final String name;
    private final List<Usage> usages;

    public Symbol(SymbolTable symbolTable, String name) {
        this.symbolTable = symbolTable;
        this.name = name;
        this.usages = new ArrayList<Usage>();
    }

    public void addUsage(ArmTree tree, Usage.Kind kind) {
        Usage usage = new Usage(tree, kind);
        this.usages.add(usage);
        if (tree instanceof HasSymbol) {
            HasSymbol treeWithSymbol = (HasSymbol)((Object)tree);
            treeWithSymbol.setSymbol(this);
        }
    }

    public boolean isUnused() {
        return this.usages.stream().noneMatch(usage -> Usage.Kind.ACCESS == usage.kind());
    }

    @CheckForNull
    public Declaration findAssignmentDeclaration() {
        return this.usages.stream().filter(usage -> Usage.Kind.ASSIGNMENT == usage.kind()).map(Usage::tree).filter(Declaration.class::isInstance).map(Declaration.class::cast).findFirst().orElse(null);
    }

    public SymbolTable symbolTable() {
        return this.symbolTable;
    }

    public String name() {
        return this.name;
    }

    public List<Usage> usages() {
        return this.usages;
    }
}

