/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.arm.checks.elementsorder;

import java.util.HashMap;
import java.util.Map;
import org.sonar.iac.arm.tree.api.FunctionCall;
import org.sonar.iac.arm.tree.api.Identifier;
import org.sonar.iac.arm.tree.api.Property;
import org.sonar.iac.arm.tree.api.bicep.Decorator;
import org.sonar.iac.arm.tree.impl.bicep.ResourceDeclarationImpl;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.IacCheck;
import org.sonar.iac.common.api.checks.InitContext;
import org.sonar.iac.common.api.tree.impl.TextRange;
import org.sonar.iac.common.api.tree.impl.TextRanges;

public class ElementsOrderResourceCheckBicep
implements IacCheck {
    private static final String MESSAGE = "Reorder the elements to match the recommended order.";
    private static final String MESSAGE_DECORATOR = "Reorder the decorators to match the recommended order.";
    private static final Map<String, Integer> DECORATORS_ORDER = new HashMap<String, Integer>();
    private static final Map<String, Integer> ELEMENTS_ORDER = new HashMap<String, Integer>();
    private static final int DEFAULT_ORDER_FOR_UNKNOWN_PROPERTY = 20;

    @Override
    public void initialize(InitContext init) {
        init.register(ResourceDeclarationImpl.class, ElementsOrderResourceCheckBicep::checkResource);
        init.register(ResourceDeclarationImpl.class, ElementsOrderResourceCheckBicep::checkResourceDecorators);
    }

    private static void checkResource(CheckContext checkContext, ResourceDeclarationImpl resourceDeclaration) {
        int prevIndex = 0;
        for (Property property : resourceDeclaration.resourceProperties()) {
            Integer index = ELEMENTS_ORDER.getOrDefault(property.key().value(), 20);
            if (index < prevIndex) {
                checkContext.reportIssue(property.key(), MESSAGE);
                break;
            }
            prevIndex = index;
        }
    }

    private static void checkResourceDecorators(CheckContext checkContext, ResourceDeclarationImpl resourceDeclaration) {
        int prevIndex = 0;
        for (Decorator decorator : resourceDeclaration.decorators()) {
            Identifier identifier = ((FunctionCall)decorator.expression()).name();
            Integer index = DECORATORS_ORDER.getOrDefault(identifier.value(), 20);
            if (index < prevIndex) {
                TextRange textRange = TextRanges.merge(decorator.keyword().textRange(), identifier.textRange());
                checkContext.reportIssue(textRange, MESSAGE_DECORATOR);
                break;
            }
            prevIndex = index;
        }
    }

    static {
        ELEMENTS_ORDER.put("parent", 0);
        ELEMENTS_ORDER.put("scope", 1);
        ELEMENTS_ORDER.put("name", 2);
        ELEMENTS_ORDER.put("location", 3);
        ELEMENTS_ORDER.put("extendedLocation", 3);
        ELEMENTS_ORDER.put("zones", 4);
        ELEMENTS_ORDER.put("sku", 5);
        ELEMENTS_ORDER.put("kind", 6);
        ELEMENTS_ORDER.put("scale", 7);
        ELEMENTS_ORDER.put("plan", 8);
        ELEMENTS_ORDER.put("identity", 9);
        ELEMENTS_ORDER.put("dependsOn", 10);
        ELEMENTS_ORDER.put("tags", 11);
        ELEMENTS_ORDER.put("properties", 100);
        DECORATORS_ORDER.put("description", 1);
        DECORATORS_ORDER.put("batchSize", 2);
    }
}

