/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.arm.checks;

import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonar.check.Rule;
import org.sonar.iac.arm.checkdsl.ContextualObject;
import org.sonar.iac.arm.checkdsl.ContextualResource;
import org.sonar.iac.arm.checks.AbstractArmResourceCheck;
import org.sonar.iac.arm.checks.utils.CheckUtils;
import org.sonar.iac.arm.tree.api.Expression;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.checks.TextUtils;

@Rule(key="S6385")
public class SubscriptionOwnerCapabilitiesCheck
extends AbstractArmResourceCheck {
    private static final String MESSAGE = "Narrow the number of actions or the assignable scope of this custom role.";
    private static final String PERMISSION_MESSAGE = "Allows all actions";
    private static final String SCOPE_MESSAGE = "High scope level";
    private static final Pattern PLAIN_SUBSCRIPTION_SCOPE_PATTERN = Pattern.compile("^/subscriptions/[^/]+/?$");

    @Override
    protected void registerResourceConsumer() {
        this.register("Microsoft.Authorization/roleDefinitions", SubscriptionOwnerCapabilitiesCheck::checkSubscriptionOwnerCapabilities);
    }

    private static void checkSubscriptionOwnerCapabilities(ContextualResource resource) {
        Optional arbitraryAction = resource.list("permissions").objects().flatMap(SubscriptionOwnerCapabilitiesCheck::findArbitraryActions).findAny();
        if (arbitraryAction.isEmpty()) {
            return;
        }
        List sensitiveScopes = resource.list("assignableScopes").getItemIf(SubscriptionOwnerCapabilitiesCheck::isSensitiveScope).collect(Collectors.toList());
        if (sensitiveScopes.isEmpty()) {
            return;
        }
        List<SecondaryLocation> secondaries = sensitiveScopes.stream().map(scopeLiteral -> new SecondaryLocation((HasTextRange)scopeLiteral, SCOPE_MESSAGE)).collect(Collectors.toList());
        secondaries.add(0, new SecondaryLocation((HasTextRange)arbitraryAction.get(), PERMISSION_MESSAGE));
        resource.report(MESSAGE, secondaries);
    }

    private static Stream<Expression> findArbitraryActions(ContextualObject permissionObject) {
        return permissionObject.list("actions").getItemIf(action -> TextUtils.isValue(action, "*").isTrue());
    }

    private static boolean isSensitiveScope(Tree scope) {
        boolean hasSensitiveCall = CheckUtils.isFunctionCallWithPropertyAccess("managementGroup", "id").test((Expression)scope) || CheckUtils.isFunctionCallWithPropertyAccess("subscription", "id").test((Expression)scope);
        boolean referencesSensitiveScope = TextUtils.matchesValue(scope, s -> PLAIN_SUBSCRIPTION_SCOPE_PATTERN.matcher((CharSequence)s).matches()).isTrue() || TextUtils.matchesValue(scope, s -> s.startsWith("/providers/Microsoft.Management/managementGroups/")).isTrue();
        return hasSensitiveCall || referencesSensitiveScope;
    }
}

