/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.arm.checks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.iac.arm.tree.api.ArmTree;
import org.sonar.iac.arm.tree.api.File;
import org.sonar.iac.arm.tree.api.FunctionCall;
import org.sonar.iac.arm.tree.api.Identifier;
import org.sonar.iac.arm.tree.api.ObjectExpression;
import org.sonar.iac.arm.tree.api.ResourceDeclaration;
import org.sonar.iac.arm.tree.api.StringLiteral;
import org.sonar.iac.arm.tree.api.bicep.ModuleDeclaration;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.IacCheck;
import org.sonar.iac.common.api.checks.InitContext;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.common.api.tree.PropertyTree;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.extension.visitors.TreeContext;
import org.sonar.iac.common.extension.visitors.TreeVisitor;

@Rule(key="S1192")
public class StringLiteralDuplicatedCheck
implements IacCheck {
    private static final String MESSAGE = "Define a variable instead of duplicating this literal \"%s\" %d times.";
    private static final String SECONDARY_MESSAGE = "Duplication.";
    private static final Pattern ALLOWED_DUPLICATED_LITERALS = Pattern.compile("(?U)^[\\p{L}_][.\\-\\w]+$");
    private static final Pattern ALLOWED_VERSION_NUMBER = Pattern.compile("^\\d++[.-]\\d++[.-]\\d++[.-]*\\d*+$");
    protected static final Pattern FORMAT_STRING = Pattern.compile("(\\{\\d++(,-?\\d*)?(:[^}]+)?})++");
    public static final int THRESHOLD_DEFAULT = 5;
    public static final int MINIMAL_LITERAL_LENGTH_DEFAULT = 5;
    @RuleProperty(key="threshold", defaultValue="5")
    protected int threshold = 5;
    @RuleProperty(key="minimal_literal_length", defaultValue="5", description="Specify the minimum number of characters a string literal must have to be considered as a potential duplication")
    protected int minimalLiteralLength = 5;

    @Override
    public void initialize(InitContext init) {
        init.register(File.class, this::visitFile);
    }

    private void visitFile(CheckContext ctx, File file) {
        StringVisitor stringVisitor = new StringVisitor();
        file.statements().forEach(stringVisitor::scan);
        stringVisitor.reportDuplicates(ctx);
    }

    private class StringVisitor
    extends TreeVisitor<TreeContext> {
        private static final TreeContext DUMMY_TREE_CONTEXT = new TreeContext();
        private final Map<String, List<StringLiteral>> sameLiteralOccurrences = new HashMap<String, List<StringLiteral>>();

        public StringVisitor() {
            this.register(StringLiteral.class, (ctx, tree) -> this.visitLiteral((StringLiteral)tree));
        }

        private void scan(Tree root) {
            super.scan(DUMMY_TREE_CONTEXT, root);
        }

        private void visitLiteral(StringLiteral tree) {
            if (!this.isIgnored(tree)) {
                String value = tree.value();
                this.sameLiteralOccurrences.computeIfAbsent(value, k -> new ArrayList()).add(tree);
            }
        }

        private boolean isIgnored(StringLiteral stringLiteral) {
            String value = stringLiteral.value();
            return value.length() < StringLiteralDuplicatedCheck.this.minimalLiteralLength || StringVisitor.isResourceTypeAndApiVersionField(stringLiteral) || StringVisitor.isResourceId(stringLiteral) || this.isSchemaProperty(stringLiteral) || this.isTypeProperty(stringLiteral) || this.isEscapedFunction(stringLiteral) || StringVisitor.isModulePath(stringLiteral) || ALLOWED_DUPLICATED_LITERALS.matcher(value).matches() || ALLOWED_VERSION_NUMBER.matcher(value).matches() || FORMAT_STRING.matcher(value).matches();
        }

        private static boolean isResourceTypeAndApiVersionField(StringLiteral stringLiteral) {
            ArmTree parent = stringLiteral.parent();
            if (parent instanceof ResourceDeclaration) {
                ResourceDeclaration resource = (ResourceDeclaration)parent;
                return stringLiteral.value().contains("@") || resource.type() == stringLiteral || resource.version() == stringLiteral;
            }
            return false;
        }

        private static boolean isResourceId(StringLiteral stringLiteral) {
            FunctionCall functionCall;
            ArmTree parent = stringLiteral.parent();
            return parent instanceof FunctionCall && "resourceId".equals((functionCall = (FunctionCall)parent).name().value());
        }

        private boolean isSchemaProperty(StringLiteral stringLiteral) {
            return StringVisitor.isValueOfKey(stringLiteral, "$schema");
        }

        private boolean isTypeProperty(StringLiteral stringLiteral) {
            return StringVisitor.isValueOfKey(stringLiteral, "type");
        }

        private static boolean isValueOfKey(StringLiteral stringLiteral, String keyName) {
            Tree tree;
            ObjectExpression objectExpression;
            Optional<Tree> key;
            ArmTree parent = stringLiteral.parent();
            if (parent instanceof ObjectExpression && (key = (objectExpression = (ObjectExpression)parent).properties().stream().filter(p -> stringLiteral.equals(p.value())).map(PropertyTree::key).findAny()).isPresent() && (tree = key.get()) instanceof Identifier) {
                Identifier identifier = (Identifier)tree;
                return identifier.value().equals(keyName);
            }
            return false;
        }

        private boolean isEscapedFunction(StringLiteral stringLiteral) {
            String value = stringLiteral.value();
            return value.startsWith("[[") && value.endsWith("]");
        }

        private static boolean isModulePath(StringLiteral stringLiteral) {
            ModuleDeclaration moduleDeclaration;
            ArmTree armTree = stringLiteral.parent();
            return armTree instanceof ModuleDeclaration && (moduleDeclaration = (ModuleDeclaration)armTree).type().equals(stringLiteral);
        }

        private void reportDuplicates(CheckContext ctx) {
            for (Map.Entry<String, List<StringLiteral>> literalOccurrences : this.sameLiteralOccurrences.entrySet()) {
                List<StringLiteral> occurrences = literalOccurrences.getValue();
                if (occurrences.size() < StringLiteralDuplicatedCheck.this.threshold) continue;
                String literal = literalOccurrences.getKey();
                String message = StringLiteralDuplicatedCheck.MESSAGE.formatted(literal, occurrences.size());
                StringLiteral firstOccurrenceTree = occurrences.get(0);
                List<SecondaryLocation> otherOccurrencesLocation = occurrences.stream().skip(1L).map(o -> new SecondaryLocation((HasTextRange)o, StringLiteralDuplicatedCheck.SECONDARY_MESSAGE)).toList();
                ctx.reportIssue((HasTextRange)firstOccurrenceTree, message, otherOccurrencesLocation);
            }
        }
    }
}

