/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.arm.checks;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.iac.arm.tree.api.ArmTree;
import org.sonar.iac.arm.tree.api.ParameterDeclaration;
import org.sonar.iac.arm.tree.api.VariableDeclaration;
import org.sonar.iac.arm.tree.api.bicep.Declaration;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.IacCheck;
import org.sonar.iac.common.api.checks.InitContext;

@Rule(key="S117")
public class ParameterAndVariableNameConventionCheck
implements IacCheck {
    private static final String MESSAGE = "Rename this %s \"%s\" to match the regular expression '%s'.";
    private static final String DEFAULT_FORMAT = "^[a-z][a-zA-Z0-9]*$";
    @RuleProperty(key="format", description="Regular expression used to check the names of variables and parameters against.", defaultValue="^[a-z][a-zA-Z0-9]*$")
    public String format = "^[a-z][a-zA-Z0-9]*$";
    private Pattern pattern;

    @Override
    public void initialize(InitContext init) {
        this.pattern = Pattern.compile(this.format);
        init.register(ParameterDeclaration.class, this::check);
        init.register(VariableDeclaration.class, this::check);
    }

    private void check(CheckContext checkContext, Declaration declaration) {
        String name = declaration.declaratedName().value();
        Matcher matcher = this.pattern.matcher(name);
        if (!matcher.matches()) {
            String type = "variable";
            if (declaration.is(ArmTree.Kind.PARAMETER_DECLARATION)) {
                type = "parameter";
            }
            String message = MESSAGE.formatted(type, name, this.format);
            checkContext.reportIssue(declaration.declaratedName(), message);
        }
    }
}

