/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.arm.checks;

import java.util.Locale;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.iac.arm.symbols.Symbol;
import org.sonar.iac.arm.tree.api.ArmTree;
import org.sonar.iac.arm.tree.api.Expression;
import org.sonar.iac.arm.tree.api.HasSymbol;
import org.sonar.iac.arm.tree.api.ParameterDeclaration;
import org.sonar.iac.arm.tree.api.Property;
import org.sonar.iac.arm.tree.api.ResourceDeclaration;
import org.sonar.iac.arm.tree.impl.bicep.ParameterDeclarationImpl;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.IacCheck;
import org.sonar.iac.common.api.checks.InitContext;

@Rule(key="S6953")
public class LocationParameterAllowedValuesCheck
implements IacCheck {
    private static final String MESSAGE_BICEP = "Remove this @allowed decorator from the parameter specifying the location.";
    private static final String MESSAGE_JSON = "Remove this allowedValues property from the parameter specifying the location.";

    @Override
    public void initialize(InitContext init) {
        init.register(ResourceDeclaration.class, LocationParameterAllowedValuesCheck::checkResourceLocation);
    }

    private static void checkResourceLocation(CheckContext checkContext, ResourceDeclaration resourceDeclaration) {
        resourceDeclaration.resourceProperties().stream().filter(property -> "location".equals(property.key().value().toLowerCase(Locale.ROOT))).map(Property::value).forEach(expression -> LocationParameterAllowedValuesCheck.reportIfParameterWithAllowedValuesIsUsed(checkContext, expression));
    }

    private static void reportIfParameterWithAllowedValuesIsUsed(CheckContext checkContext, Expression expression) {
        if (expression instanceof HasSymbol) {
            HasSymbol expressionWithSymbol = (HasSymbol)((Object)expression);
            Optional.ofNullable(expressionWithSymbol.symbol()).map(Symbol::findAssignmentDeclaration).filter(declaration -> declaration.is(ArmTree.Kind.PARAMETER_DECLARATION)).map(ParameterDeclaration.class::cast).filter(parameterDeclaration -> !parameterDeclaration.allowedValues().isEmpty()).ifPresent(declaration -> LocationParameterAllowedValuesCheck.reportOnDeclaration(checkContext, declaration));
        }
    }

    private static void reportOnDeclaration(CheckContext checkContext, ParameterDeclaration declaration) {
        ArmTree treeToRaiseOn = declaration.allowedValues().get(0).parent();
        boolean isBicep = declaration instanceof ParameterDeclarationImpl;
        if (isBicep) {
            treeToRaiseOn = treeToRaiseOn.parent();
        }
        if (treeToRaiseOn != null) {
            checkContext.reportIssue(treeToRaiseOn, isBicep ? MESSAGE_BICEP : MESSAGE_JSON);
        }
    }
}

