/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.arm.checks;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.IacCheck;
import org.sonar.iac.common.api.checks.InitContext;
import org.sonar.iac.common.api.tree.HasProperties;
import org.sonar.iac.common.api.tree.PropertyTree;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.checks.TextUtils;

@Rule(key="S6437")
public class HardCodedCredentialsCheck
implements IacCheck {
    private static final String MESSAGE = "Revoke and change this secret, as it might be compromised.";
    private static final List<String> CREDENTIAL_PROPERTIES = List.of("administratorLogin", "administratorLoginPassword", "password", "secret", "adminPassword", "adminUsername", "publishingPassword", "publishingUserName");

    @Override
    public void initialize(InitContext init) {
        init.register(Tree.class, HardCodedCredentialsCheck::checkCredentials);
    }

    private static void checkCredentials(CheckContext ctx, Tree tree) {
        if (tree instanceof HasProperties) {
            HasProperties hasProperties = (HasProperties)((Object)tree);
            for (PropertyTree property : hasProperties.properties()) {
                TextUtils.getValue(property.key()).ifPresent(propertyName -> {
                    if (CREDENTIAL_PROPERTIES.contains(propertyName) && HardCodedCredentialsCheck.isHardcoded(property.value())) {
                        ctx.reportIssue(property, MESSAGE);
                    }
                });
            }
        }
    }

    private static boolean isHardcoded(Tree tree) {
        return TextUtils.matchesValue(tree, String::isBlank).isFalse();
    }
}

