/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.arm.checks;

import java.util.function.Consumer;
import java.util.function.Predicate;
import org.sonar.check.Rule;
import org.sonar.iac.arm.checkdsl.ContextualResource;
import org.sonar.iac.arm.checks.AbstractArmResourceCheck;
import org.sonar.iac.arm.checks.utils.CheckUtils;
import org.sonar.iac.arm.tree.api.Expression;
import org.sonar.iac.common.api.checks.SecondaryLocation;

@Rule(key="S4507")
public class DebugSettingCheck
extends AbstractArmResourceCheck {
    private static final String MESSAGE = "Make sure this debug feature is deactivated before delivering the code in production.";
    private static final Predicate<Expression> SENSITIVE_DETAIL_LEVEL = detailLevel -> CheckUtils.contains("RequestContent").or(CheckUtils.contains("ResponseContent")).test((Expression)detailLevel);

    @Override
    protected void registerResourceConsumer() {
        this.register("Microsoft.Resources/deployments", DebugSettingCheck.checkDebugSetting());
    }

    private static Consumer<ContextualResource> checkDebugSetting() {
        return resource -> {
            if (resource.object("debugSetting").property("detailLevel").is(SENSITIVE_DETAIL_LEVEL)) {
                resource.property("debugSetting").report(MESSAGE, new SecondaryLocation[0]);
            }
        };
    }
}

