/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.arm.checks;

import java.util.List;
import java.util.function.Consumer;
import org.sonar.check.Rule;
import org.sonar.iac.arm.checkdsl.ContextualProperty;
import org.sonar.iac.arm.checkdsl.ContextualResource;
import org.sonar.iac.arm.checks.AbstractArmResourceCheck;
import org.sonar.iac.arm.checks.utils.CheckUtils;
import org.sonar.iac.common.api.checks.SecondaryLocation;

@Rule(key="S5332")
public class ClearTextProtocolsCheck
extends AbstractArmResourceCheck {
    private static final String GENERAL_ISSUE_MESSAGE = "Make sure that using clear-text protocols is safe here.";
    private static final String ISSUE_MESSAGE_ON_MISSING_PROPERTY = "Omitting \"%s\" allows the use of clear-text protocols. Make sure it is safe here.";
    private static final List<String> DATABASE_SERVER_TYPES = List.of("Microsoft.DBforMySQL/servers", "Microsoft.DBforMariaDB/servers", "Microsoft.DBforPostgreSQL/servers");

    @Override
    protected void registerResourceConsumer() {
        this.register("Microsoft.Web/sites", ClearTextProtocolsCheck.checkPropertyIsNotSetOrFalse("httpsOnly"));
        this.register("Microsoft.Web/sites/config", ClearTextProtocolsCheck.checkPropertyHasValue("ftpsState", "AllAllowed"));
        this.register("Microsoft.Storage/storageAccounts", ClearTextProtocolsCheck::checkHttpsTraffic);
        this.register("Microsoft.ApiManagement/service/apis", ClearTextProtocolsCheck::checkProtocols);
        this.register("Microsoft.Cdn/profiles/endpoints", ClearTextProtocolsCheck.checkPropertyIsNotSetOrFalse("isHttpAllowed"));
        this.register("Microsoft.Cache/redisEnterprise/databases", ClearTextProtocolsCheck.checkPropertyHasValue("clientProtocol", "Plaintext"));
        this.register(DATABASE_SERVER_TYPES, ClearTextProtocolsCheck.checkPropertyHasValue("sslEnforcement", "Disabled"));
    }

    private static Consumer<ContextualResource> checkPropertyIsNotSetOrFalse(String propertyName) {
        return resource -> ((ContextualProperty)resource.property(propertyName).reportIfAbsent(ISSUE_MESSAGE_ON_MISSING_PROPERTY, new SecondaryLocation[0])).reportIf(CheckUtils.isFalse(), GENERAL_ISSUE_MESSAGE, new SecondaryLocation[0]);
    }

    private static Consumer<ContextualResource> checkPropertyHasValue(String propertyName, String value) {
        return resource -> resource.property(propertyName).reportIf(CheckUtils.isEqual(value), GENERAL_ISSUE_MESSAGE, new SecondaryLocation[0]);
    }

    private static void checkHttpsTraffic(ContextualResource resource) {
        resource.property("supportsHttpsTrafficOnly").reportIf(CheckUtils.isFalse(), GENERAL_ISSUE_MESSAGE, new SecondaryLocation[0]);
    }

    private static void checkProtocols(ContextualResource resource) {
        resource.list("protocols").reportItemIf(CheckUtils.isEqual("http"), GENERAL_ISSUE_MESSAGE, new SecondaryLocation[0]);
    }
}

