/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.arm.checks;

import java.util.List;
import java.util.function.Predicate;
import org.sonar.check.Rule;
import org.sonar.iac.arm.checkdsl.ContextualObject;
import org.sonar.iac.arm.checkdsl.ContextualProperty;
import org.sonar.iac.arm.checkdsl.ContextualResource;
import org.sonar.iac.arm.checks.AbstractArmResourceCheck;
import org.sonar.iac.arm.checks.utils.CheckUtils;
import org.sonar.iac.arm.tree.api.Expression;
import org.sonar.iac.arm.tree.api.ResourceDeclaration;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.common.checks.TextUtils;

@Rule(key="S6380")
public class AnonymousAccessToResourceCheck
extends AbstractArmResourceCheck {
    private static final String DISABLED_AUTH_MESSAGE = "Make sure that disabling authentication is safe here.";
    private static final String WEBSITES_CONFIG_AUTH_SETTINGS_V2_RESOURCE_NAME = "authsettingsV2";
    private static final String WEBSITES_MISSING_AUTH_SETTINGS_MESSAGE = "Omitting authsettingsV2 disables authentication. Make sure it is safe here.";
    private static final String APIMGMT_PORTALSETTINGS_SIGNIN_RESOURCE_NAME = "signin";
    private static final String APIMGMT_PORTAL_SETTINGS_DISABLED_MESSAGE = "Make sure that giving anonymous access without enforcing sign-in is safe here.";
    private static final String APIMGMT_MISSING_SIGN_IN_RESOURCE_MESSAGE = "Omitting sign_in authorizes anonymous access. Make sure it is safe here.";
    private static final String APIMGMT_AUTHENTICATION_SETTINGS_NOT_SET_MESSAGE = "Omitting authenticationSettings disables authentication. Make sure it is safe here.";
    private static final String STORAGE_ANONYMOUS_ACCESS_MESSAGE = "Make sure that authorizing potential anonymous access is safe here.";
    private static final String DATA_FACTORY_ANONYMOUS_ACCESS_MESSAGE = "Make sure that authorizing anonymous access is safe here.";
    private static final List<String> DATA_FACTORY_SENSITIVE_TYPES = List.of("AzureBlobStorage", "FtpServer", "HBase", "Hive", "HttpServer", "Impala", "MongoDb", "OData", "Phoenix", "Presto", "RestService", "Spark", "Web");
    private static final Predicate<Expression> VERSION_DENIES_BLOB_PUBLIC_ACCESS_BY_DEFAULT = CheckUtils.isVersionNewerOrEqualThan("2023-01-01");

    @Override
    protected void registerResourceConsumer() {
        this.register("Microsoft.Web/sites", AnonymousAccessToResourceCheck::checkWebSites);
        this.register("Microsoft.Web/sites/config", AnonymousAccessToResourceCheck::checkWebSitesAuthSettings);
        this.register("Microsoft.ApiManagement/service", AnonymousAccessToResourceCheck::checkApiManagementService);
        this.register("Microsoft.ApiManagement/service/portalsettings", AnonymousAccessToResourceCheck::checkApiManagementPortalSettings);
        this.register("Microsoft.ApiManagement/service/apis", AnonymousAccessToResourceCheck::checkApiManagementServiceApis);
        this.register("Microsoft.Storage/storageAccounts", AnonymousAccessToResourceCheck::checkStorageAccounts);
        this.register("Microsoft.Storage/storageAccounts/blobServices/containers", AnonymousAccessToResourceCheck::checkStorageAccountContainers);
        this.register("Microsoft.Cache/redis", AnonymousAccessToResourceCheck::checkRedisCache);
        this.register("Microsoft.DataFactory/factories/linkedservices", AnonymousAccessToResourceCheck::checkDataFactories);
    }

    private static void checkWebSites(ContextualResource resource) {
        ContextualResource authSettingsV2 = resource.childResourceBy("config", it -> TextUtils.isValue(it.name(), WEBSITES_CONFIG_AUTH_SETTINGS_V2_RESOURCE_NAME).isTrue());
        if (authSettingsV2.isAbsent()) {
            resource.report(WEBSITES_MISSING_AUTH_SETTINGS_MESSAGE, new SecondaryLocation[0]);
        }
    }

    private static void checkWebSitesAuthSettings(ContextualResource contextualResource) {
        if (!TextUtils.isValue(((ResourceDeclaration)contextualResource.tree).name(), WEBSITES_CONFIG_AUTH_SETTINGS_V2_RESOURCE_NAME).isTrue()) {
            return;
        }
        ContextualObject globalValidation = contextualResource.object("globalValidation");
        globalValidation.property("requireAuthentication").reportIf(CheckUtils.isFalse(), DISABLED_AUTH_MESSAGE, new SecondaryLocation[0]);
        globalValidation.property("unauthenticatedClientAction").reportIf(CheckUtils.isEqual("AllowAnonymous"), DISABLED_AUTH_MESSAGE, new SecondaryLocation[0]);
    }

    private static void checkApiManagementService(ContextualResource resource) {
        ContextualResource signIn = resource.childResourceBy("portalsettings", it -> TextUtils.isValue(it.name(), APIMGMT_PORTALSETTINGS_SIGNIN_RESOURCE_NAME).isTrue());
        if (signIn.isAbsent()) {
            resource.report(APIMGMT_MISSING_SIGN_IN_RESOURCE_MESSAGE, new SecondaryLocation[0]);
        }
    }

    private static void checkApiManagementPortalSettings(ContextualResource resource) {
        if (!TextUtils.isValue(((ResourceDeclaration)resource.tree).name(), APIMGMT_PORTALSETTINGS_SIGNIN_RESOURCE_NAME).isTrue()) {
            return;
        }
        resource.property("enabled").reportIf(CheckUtils.isFalse(), APIMGMT_PORTAL_SETTINGS_DISABLED_MESSAGE, new SecondaryLocation[0]);
    }

    private static void checkApiManagementServiceApis(ContextualResource resource) {
        resource.property("authenticationSettings").reportIfAbsent(APIMGMT_AUTHENTICATION_SETTINGS_NOT_SET_MESSAGE, new SecondaryLocation[0]);
    }

    private static void checkStorageAccounts(ContextualResource resource) {
        ContextualProperty allowBlobPublicAccess = resource.property("allowBlobPublicAccess");
        allowBlobPublicAccess.reportIf(CheckUtils.isTrue(), STORAGE_ANONYMOUS_ACCESS_MESSAGE, new SecondaryLocation[0]);
        if (!VERSION_DENIES_BLOB_PUBLIC_ACCESS_BY_DEFAULT.test(resource.version)) {
            allowBlobPublicAccess.reportIfAbsent(STORAGE_ANONYMOUS_ACCESS_MESSAGE, new SecondaryLocation[0]);
        }
    }

    private static void checkStorageAccountContainers(ContextualResource resource) {
        resource.property("publicAccess").reportIf(CheckUtils.isEqual("Blob"), STORAGE_ANONYMOUS_ACCESS_MESSAGE, new SecondaryLocation[0]);
    }

    private static void checkRedisCache(ContextualResource resource) {
        resource.object("redisConfiguration").property("authnotrequired").reportIf(TextUtils::isValueTrue, DISABLED_AUTH_MESSAGE, new SecondaryLocation[0]);
    }

    private static void checkDataFactories(ContextualResource resource) {
        if (!resource.property("type").is(CheckUtils.inCollection(DATA_FACTORY_SENSITIVE_TYPES))) {
            return;
        }
        resource.object("typeProperties").property("authenticationType").reportIf(CheckUtils.isEqual("Anonymous"), DATA_FACTORY_ANONYMOUS_ACCESS_MESSAGE, new SecondaryLocation[0]);
    }
}

