/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.arm.checks;

import org.sonar.iac.arm.symbols.SymbolTable;
import org.sonar.iac.arm.tree.api.ArmTree;
import org.sonar.iac.arm.tree.api.File;
import org.sonar.iac.arm.tree.api.bicep.Declaration;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.IacCheck;
import org.sonar.iac.common.api.checks.InitContext;

abstract class AbstractUnusedSymbolCheck
implements IacCheck {
    private static final String MESSAGE = "Remove the unused %s \"%s\".";

    AbstractUnusedSymbolCheck() {
    }

    @Override
    public void initialize(InitContext init) {
        init.register(File.class, this::checkSymbols);
    }

    abstract ArmTree.Kind declarationKind();

    abstract String typeOfSymbol();

    void checkSymbols(CheckContext checkContext, File file) {
        SymbolTable symbolTable = file.symbolTable();
        if (symbolTable != null && !symbolTable.hasFoundUnresolvableSymbolAccess()) {
            symbolTable.getSymbols().forEach(symbol -> {
                Declaration declaration = symbol.findAssignmentDeclaration();
                if (declaration != null && this.declarationKind() == declaration.getKind() && symbol.isUnused()) {
                    this.reportOnDeclaration(checkContext, declaration);
                }
            });
        }
    }

    private void reportOnDeclaration(CheckContext checkContext, Declaration declaration) {
        checkContext.reportIssue(declaration.declaratedName(), MESSAGE.formatted(this.typeOfSymbol(), declaration.declaratedName().value()));
    }
}

