/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.arm.checks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.sonar.iac.arm.checkdsl.ContextualResource;
import org.sonar.iac.arm.tree.api.ResourceDeclaration;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.IacCheck;
import org.sonar.iac.common.api.checks.InitContext;

abstract class AbstractArmResourceCheck
implements IacCheck {
    private final Map<String, List<BiConsumer<CheckContext, ResourceDeclaration>>> resourceTreeConsumers = new HashMap<String, List<BiConsumer<CheckContext, ResourceDeclaration>>>();
    private final Map<String, List<Consumer<ContextualResource>>> contextualResourceConsumer = new HashMap<String, List<Consumer<ContextualResource>>>();

    AbstractArmResourceCheck() {
    }

    @Override
    public void initialize(InitContext init) {
        init.register(ResourceDeclaration.class, this::provideResource);
        this.registerResourceConsumer();
    }

    protected void provideResource(CheckContext ctx, ResourceDeclaration resource) {
        String resourceType = resource.type().value();
        this.processResource(ctx, resource, resourceType);
    }

    private void processResource(CheckContext ctx, ResourceDeclaration resource, String resourceType) {
        if (this.resourceTreeConsumers.containsKey(resourceType)) {
            this.resourceTreeConsumers.get(resourceType).forEach(consumer -> consumer.accept(ctx, resource));
        }
        if (this.contextualResourceConsumer.containsKey(resourceType)) {
            ContextualResource symbol = ContextualResource.fromPresent(ctx, resource, resourceType);
            this.contextualResourceConsumer.get(resourceType).forEach(consumer -> consumer.accept(symbol));
        }
        resource.childResources().forEach(child -> {
            String childResourceType = resourceType + "/" + child.type().value();
            this.processResource(ctx, (ResourceDeclaration)child, childResourceType);
        });
    }

    protected abstract void registerResourceConsumer();

    protected void register(String resourceType, BiConsumer<CheckContext, ResourceDeclaration> consumer) {
        this.resourceTreeConsumers.computeIfAbsent(resourceType, i -> new ArrayList()).add(consumer);
    }

    protected void register(List<String> resourceTypes, BiConsumer<CheckContext, ResourceDeclaration> consumer) {
        resourceTypes.forEach(resourceType -> this.register((String)resourceType, consumer));
    }

    protected void register(String resourceType, Consumer<ContextualResource> consumer) {
        this.contextualResourceConsumer.computeIfAbsent(resourceType, i -> new ArrayList()).add(consumer);
    }

    protected void register(List<String> resourceTypes, Consumer<ContextualResource> consumer) {
        resourceTypes.forEach(resourceType -> this.register((String)resourceType, consumer));
    }
}

