/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.utils.Version;

public class ExternalReportProvider {
    private static final Logger LOG = LoggerFactory.getLogger(ExternalReportProvider.class);

    private ExternalReportProvider() {
    }

    public static List<File> getReportFiles(SensorContext context, String externalReportsProperty) {
        boolean externalIssuesSupported = context.runtime().getApiVersion().isGreaterThanOrEqual(Version.create(7, 2));
        String[] reportPaths = context.config().getStringArray(externalReportsProperty);
        if (reportPaths.length == 0) {
            return Collections.emptyList();
        }
        if (!externalIssuesSupported) {
            LOG.error("Import of external issues requires SonarQube 7.2 or greater.");
            return Collections.emptyList();
        }
        ArrayList<File> result = new ArrayList<File>();
        for (String reportPath : reportPaths) {
            File report = ExternalReportProvider.getIOFile(context.fileSystem().baseDir(), reportPath);
            result.add(report);
        }
        return result;
    }

    private static File getIOFile(File baseDir, String path) {
        File file = new File(path);
        if (!file.isAbsolute()) {
            file = new File(baseDir, path);
        }
        return file;
    }
}

