/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.checks.gcp;

import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.common.checks.TextUtils;
import org.sonar.iac.terraform.api.tree.ExpressionTree;
import org.sonar.iac.terraform.checks.AbstractNewResourceCheck;
import org.sonar.iac.terraform.symbols.ListSymbol;
import org.sonar.iac.terraform.symbols.ResourceSymbol;

@Rule(key="S6406")
public class ExcessivePermissionsCheck
extends AbstractNewResourceCheck {
    private static final String MESSAGE = "This role grants more than %d sensitive permissions. Make sure they are all required.";
    private static final String SECONDARY_MESSAGE = "Sensitive permission";
    public static final int DEFAULT = 5;
    private static final List<String> SENSITIVE_ACTION_PREFIXES = List.of("abort", "access", "add", "allocate", "analyze", "apply", "approve", "associate", "attach", "begin", "bind", "call", "cancel", "clear", "close", "compute", "connect", "create", "delete", "deploy", "destroy", "detach", "disable", "drop", "enable", "evict", "exec", "import", "install", "invoke", "listVulnerabilities", "manage", "migrate", "move", "mutate", "patch", "pause", "proxy", "publish", "purchase", "purge", "put", "reject", "remove", "reopen", "replace", "rerun", "reset", "resize", "restart", "restore", "resume", "rollback", "rotate", "run", "sample", "scan", "send", "set", "sign", "sourceCodeGet", "sourceCodeSet", "start", "stop", "suspend", "undelete", "undeploy", "update", "upload", "use", "validate", "write");
    private static final List<String> SENSITIVE_ACTION_ELEMENTS = List.of("login", "create", "delete", "set");
    @RuleProperty(key="max", defaultValue="5")
    public int max = 5;

    @Override
    protected void registerResourceConsumer() {
        this.register(Set.of("google_organization_iam_custom_role", "google_project_iam_custom_role"), (ResourceSymbol resource) -> {
            ListSymbol permissions = resource.list("permissions");
            List<ExpressionTree> sensitivePermissions = resource.list("permissions").getItemIf(ExcessivePermissionsCheck.isSensitivePermission()).toList();
            if (sensitivePermissions.size() > this.max) {
                List<SecondaryLocation> secondaries = sensitivePermissions.stream().map(p -> new SecondaryLocation((HasTextRange)p, SECONDARY_MESSAGE)).toList();
                permissions.report(String.format(MESSAGE, this.max), secondaries);
            }
        });
    }

    private static Predicate<ExpressionTree> isSensitivePermission() {
        return expression -> TextUtils.getValue(expression).map(String::toLowerCase).map(ExcessivePermissionsCheck::getPermissionSuffix).filter(suffix -> !suffix.contains("readonly")).filter(ExcessivePermissionsCheck::isSensitiveSuffix).isPresent();
    }

    private static String getPermissionSuffix(String permission) {
        return permission.substring(permission.lastIndexOf(".") + 1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isSensitiveSuffix(String suffix) {
        if (SENSITIVE_ACTION_PREFIXES.stream().anyMatch(suffix::startsWith)) return true;
        if (!SENSITIVE_ACTION_ELEMENTS.stream().anyMatch(suffix::contains)) return false;
        return true;
    }
}

