/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.checks.azure;

import org.sonar.check.Rule;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.common.checks.PropertyUtils;
import org.sonar.iac.common.checks.TextUtils;
import org.sonar.iac.terraform.api.tree.AttributeTree;
import org.sonar.iac.terraform.api.tree.BlockTree;
import org.sonar.iac.terraform.checks.AbstractResourceCheck;

@Rule(key="S6379")
public class ResourceSpecificAdminAccountCheck
extends AbstractResourceCheck {
    private static final String MESSAGE = "Make sure that enabling an administrative account or administrative permissions is safe here.";

    @Override
    protected void registerResourceChecks() {
        this.register(ResourceSpecificAdminAccountCheck::checkContainerRegistry, "azurerm_container_registry");
        this.register(ResourceSpecificAdminAccountCheck::checkBatchPool, "azurerm_batch_pool");
    }

    private static void checkContainerRegistry(CheckContext ctx, BlockTree resource) {
        PropertyUtils.get(resource, "admin_enabled", AttributeTree.class).filter(attr -> TextUtils.isValueTrue(attr.value())).ifPresent(attr -> ctx.reportIssue((HasTextRange)attr, MESSAGE));
    }

    private static void checkBatchPool(CheckContext ctx, BlockTree resource) {
        PropertyUtils.get(resource, "start_task", BlockTree.class).flatMap(startTask -> PropertyUtils.get(startTask, "user_identity", BlockTree.class)).flatMap(userIdentity -> PropertyUtils.get(userIdentity, "auto_user", BlockTree.class)).flatMap(autoUser -> PropertyUtils.get(autoUser, "elevation_level", AttributeTree.class)).filter(attr -> TextUtils.isValue(attr.value(), "Admin").isTrue()).ifPresent(attr -> ctx.reportIssue((HasTextRange)attr, MESSAGE));
    }
}

