/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.checks;

import org.sonar.api.utils.Version;
import org.sonar.check.Rule;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.terraform.checks.AbstractNewResourceCheck;
import org.sonar.iac.terraform.plugin.TerraformProviders;
import org.sonar.iac.terraform.symbols.ResourceSymbol;

@Rule(key="S6245")
public class DisabledS3EncryptionCheck
extends AbstractNewResourceCheck {
    private static final String MESSAGE = "Omitting \"server_side_encryption_configuration\" disables server-side encryption. Make sure it is safe here.";
    private static final Version AWS_V_4 = Version.create(4, 0);

    @Override
    protected void registerResourceConsumer() {
        this.register("aws_s3_bucket", (ResourceSymbol resource) -> {
            if (resource.provider(TerraformProviders.Provider.Identifier.AWS).hasVersionLowerThan(AWS_V_4) && resource.block("server_side_encryption_configuration").isAbsent() && resource.attribute("server_side_encryption_configuration").isAbsent()) {
                resource.report(MESSAGE, new SecondaryLocation[0]);
            }
        });
    }
}

