/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.springconfig.plugin.visitors;

import org.sonar.api.batch.sensor.highlighting.TypeOfText;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.common.extension.visitors.SyntaxHighlightingVisitor;
import org.sonar.iac.springconfig.plugin.SpringConfigSensor;
import org.sonar.iac.springconfig.tree.api.Scalar;
import org.sonar.iac.springconfig.tree.api.Tuple;
import org.sonar.iac.springconfig.tree.utils.SpringConfigUtils;

public class SpringConfigHighlightingVisitor
extends SyntaxHighlightingVisitor {
    @Override
    protected void languageSpecificHighlighting() {
        this.register(Tuple.class, (ctx, tree) -> {
            if (SpringConfigSensor.isPropertiesFile(ctx)) {
                this.highlight(tree.key(), TypeOfText.KEYWORD);
            }
        });
        this.register(Scalar.class, (ctx, tree) -> ctx.ancestors().stream().findFirst().map(Tuple.class::cast).filter(tuple -> !tuple.key().equals(tree)).filter(tuple -> !SpringConfigHighlightingVisitor.hasAbsentOrEmptyValue(tuple)).ifPresent(ignored -> this.highlight((HasTextRange)tree, TypeOfText.STRING)));
    }

    private static boolean hasAbsentOrEmptyValue(Tuple tuple) {
        String stringValue = SpringConfigUtils.getStringValue(tuple);
        return stringValue == null || stringValue.isEmpty();
    }
}

