/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.springconfig.parser.properties;

import java.util.ArrayList;
import org.antlr.v4.runtime.ParserRuleContext;
import org.sonar.iac.common.api.tree.Comment;
import org.sonar.iac.common.api.tree.impl.CommentImpl;
import org.sonar.iac.common.api.tree.impl.TextRange;
import org.sonar.iac.common.api.tree.impl.TextRanges;
import org.sonar.iac.springconfig.parser.SpringConfigProfileNameUtil;
import org.sonar.iac.springconfig.parser.properties.PropertiesParser;
import org.sonar.iac.springconfig.parser.properties.PropertiesParserBaseVisitor;
import org.sonar.iac.springconfig.tree.api.Profile;
import org.sonar.iac.springconfig.tree.api.Scalar;
import org.sonar.iac.springconfig.tree.api.SpringConfig;
import org.sonar.iac.springconfig.tree.api.Tuple;
import org.sonar.iac.springconfig.tree.impl.FileImpl;
import org.sonar.iac.springconfig.tree.impl.ProfileImpl;
import org.sonar.iac.springconfig.tree.impl.ScalarImpl;
import org.sonar.iac.springconfig.tree.impl.SyntaxTokenImpl;
import org.sonar.iac.springconfig.tree.impl.TupleImpl;

public class PropertiesParseTreeVisitor
extends PropertiesParserBaseVisitor<SpringConfig> {
    @Override
    public SpringConfig visitPropertiesFile(PropertiesParser.PropertiesFileContext ctx) {
        super.visitPropertiesFile(ctx);
        ArrayList<Tuple> properties = new ArrayList<Tuple>();
        ArrayList<Comment> comments = new ArrayList<Comment>();
        ArrayList<Profile> profiles = new ArrayList<Profile>();
        for (PropertiesParser.RowContext row : ctx.row()) {
            if (row.line() != null) {
                Scalar keyScalar = PropertiesParseTreeVisitor.createKeyScalar(row);
                Scalar valueScalar = PropertiesParseTreeVisitor.createValueScalar(row);
                properties.add(new TupleImpl(keyScalar, valueScalar));
            }
            if (row.comment() == null) continue;
            Comment comment = PropertiesParseTreeVisitor.createComment(row);
            if ("#---".equals(comment.value()) || "!---".equals(comment.value())) {
                ProfileImpl profile = new ProfileImpl(properties, comments, SpringConfigProfileNameUtil.profileName(properties), true);
                profiles.add(profile);
                properties = new ArrayList();
                comments = new ArrayList();
            }
            comments.add(comment);
        }
        ProfileImpl profile = new ProfileImpl(properties, comments, SpringConfigProfileNameUtil.profileName(properties), true);
        profiles.add(profile);
        return new FileImpl(profiles);
    }

    private static Scalar createKeyScalar(PropertiesParser.RowContext row) {
        PropertiesParser.KeyContext keyContext = row.line().key().get(0);
        String keyText = keyContext.getText();
        return new ScalarImpl(new SyntaxTokenImpl(keyText, PropertiesParseTreeVisitor.textRange(keyContext)));
    }

    private static Scalar createValueScalar(PropertiesParser.RowContext row) {
        ScalarImpl valueScalar = null;
        if (row.line().key().size() == 2) {
            PropertiesParser.KeyContext valueContext = row.line().key().get(1);
            String valueText = valueContext.getText();
            valueScalar = new ScalarImpl(new SyntaxTokenImpl(valueText, PropertiesParseTreeVisitor.textRange(valueContext)));
        }
        return valueScalar;
    }

    private static Comment createComment(PropertiesParser.RowContext row) {
        PropertiesParser.CommentStartAndTextContext commentContext = row.comment().commentStartAndText();
        String value = commentContext.getText();
        String contentText = commentContext.commentText().getText();
        return new CommentImpl(value, contentText, PropertiesParseTreeVisitor.textRange(commentContext));
    }

    private static TextRange textRange(ParserRuleContext ctx) {
        return TextRanges.range(ctx.start.getLine(), ctx.start.getCharPositionInLine(), ctx.stop.getLine(), ctx.stop.getCharPositionInLine() + 1);
    }
}

