/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.springconfig.parser.properties;

import javax.annotation.Nullable;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.iac.common.extension.BasicTextPointer;
import org.sonar.iac.common.extension.ExceptionUtils;
import org.sonar.iac.common.extension.ParseException;
import org.sonar.iac.common.extension.visitors.InputFileContext;

public class ErrorListener
extends BaseErrorListener {
    private static final Logger LOG = LoggerFactory.getLogger(ErrorListener.class);
    @Nullable
    private InputFileContext inputFileContext;

    public ErrorListener(@Nullable InputFileContext inputFileContext) {
        this.inputFileContext = inputFileContext;
    }

    @Override
    public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, @Nullable RecognitionException e) {
        BasicTextPointer textPointer = new BasicTextPointer(line, charPositionInLine);
        String message = "Cannot parse, " + msg;
        LOG.debug(message);
        if (e != null) {
            String stackTrace = ExceptionUtils.getStackTrace(e);
            LOG.debug(stackTrace);
        }
        throw ParseException.createParseException(message, this.inputFileContext, textPointer);
    }
}

