/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.springconfig.checks;

import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.springconfig.checks.AbstractSensitiveKeyCheck;
import org.sonar.iac.springconfig.tree.api.Tuple;

@Rule(key="S5693")
public class ExcessiveFileUploadSizeLimitCheck
extends AbstractSensitiveKeyCheck {
    private static final String MESSAGE_FORMAT = "The content length limit of %s bytes is greater than the defined limit of %d; make sure it is safe here.";
    private static final Set<String> SENSITIVE_KEYS = Set.of("spring.servlet.multipart.max-file-size", "spring.servlet.multipart.max-request-size");
    private static final long MULTIPLIER = 1024L;
    private static final Pattern DATA_SIZE_PATTERN = Pattern.compile("^(?<value>[+\\-]?\\d+)(?<suffix>[a-zA-Z]{0,2})$");
    private static final long BYTES_IN_KB = 1024L;
    private static final long BYTES_IN_MB = 0x100000L;
    private static final long BYTES_IN_GB = 0x40000000L;
    private static final long BYTES_IN_TB = 0x10000000000L;
    private static final long DEFAULT_LIMIT = 0x800000L;
    @RuleProperty(key="fileUploadSizeLimit")
    public long fileUploadSizeLimit = 0x800000L;

    @Override
    protected Set<String> sensitiveKeys() {
        return SENSITIVE_KEYS;
    }

    @Override
    protected void checkValue(CheckContext ctx, Tuple tuple, String value) {
        Long valueBytes = ExcessiveFileUploadSizeLimitCheck.sizeBytes(value);
        if (valueBytes != null && valueBytes > this.fileUploadSizeLimit) {
            ctx.reportIssue(tuple, MESSAGE_FORMAT.formatted(valueBytes, this.fileUploadSizeLimit));
        }
    }

    @CheckForNull
    static Long sizeBytes(String input) {
        String normalized = input.toLowerCase(Locale.ROOT);
        Matcher matcher = DATA_SIZE_PATTERN.matcher(normalized);
        if (matcher.matches()) {
            String suffix = matcher.group("suffix");
            String value = matcher.group("value");
            return switch (suffix) {
                case "b", "" -> Long.parseLong(value);
                case "kb" -> Long.parseLong(value) * 1024L;
                case "mb" -> Long.parseLong(value) * 0x100000L;
                case "gb" -> Long.parseLong(value) * 0x40000000L;
                case "tb" -> Long.parseLong(value) * 0x10000000000L;
                default -> null;
            };
        }
        return null;
    }
}

