/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.kubernetes.visitors;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import org.snakeyaml.engine.v2.exceptions.Mark;
import org.snakeyaml.engine.v2.exceptions.MarkedYamlEngineException;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.common.api.tree.impl.TextRange;
import org.sonar.iac.common.api.tree.impl.TextRanges;
import org.sonar.iac.common.yaml.YamlFileUtils;
import org.sonar.iac.helm.ShiftedMarkedYamlEngineException;
import org.sonar.iac.helm.tree.api.GoTemplateTree;
import org.sonar.iac.helm.tree.api.Node;
import org.sonar.iac.helm.tree.utils.GoTemplateAstHelper;
import org.sonar.iac.kubernetes.visitors.HelmInputFileContext;

public final class LocationShifter {
    private LocationShifter() {
    }

    public static void addShiftedLine(HelmInputFileContext ctx, int transformedLine, int targetStartLine, int targetEndLine) {
        ctx.sourceMap().addLineData(transformedLine, targetStartLine, targetEndLine);
    }

    public static void readLinesSizes(String source, HelmInputFileContext ctx) {
        String[] lines = YamlFileUtils.splitLines(source);
        for (int lineNumber = 1; lineNumber <= lines.length; ++lineNumber) {
            LocationShifter.addLineSize(ctx, lineNumber, lines[lineNumber - 1].length());
        }
    }

    static void addLineSize(HelmInputFileContext ctx, int originalLine, int size) {
        ctx.sourceMap().originalLinesSizes.put(originalLine, size);
    }

    public static TextRange shiftLocation(HelmInputFileContext currentCtx, TextRange textRange) {
        TextRange shiftedToLine = LocationShifter.computeShiftedLocation(currentCtx, textRange);
        TextRange shiftedTextRange = LocationShifter.computeHelmExpressionToHighlightingTextRange(currentCtx, shiftedToLine);
        if (shiftedTextRange.equals(shiftedToLine)) {
            TextRange rangeWithShiftedLine = TextRanges.range(shiftedTextRange.start().line(), textRange.start().lineOffset(), shiftedTextRange.end().line(), textRange.end().lineOffset());
            if (LocationShifter.isTextRangeValid(rangeWithShiftedLine, currentCtx)) {
                return rangeWithShiftedLine;
            }
            return shiftedTextRange;
        }
        return shiftedTextRange;
    }

    public static TextRange computeShiftedLocation(HelmInputFileContext ctx, TextRange textRange) {
        LinesShifting shifting = ctx.sourceMap();
        if (shifting.isNotInitialized()) {
            return textRange;
        }
        int lineStart = textRange.start().line();
        int lineEnd = textRange.end().line();
        Integer rangeStart = shifting.getClosestLineData(lineStart).map(p -> p.targetStartLine).orElse(shifting.getLastOriginalLine());
        Optional<LineData> endLineData = shifting.getClosestLineData(lineEnd);
        Integer rangeEnd = endLineData.map(p -> p.targetEndLine).orElse(shifting.getLastOriginalLine());
        Integer rangeEndLineLength = ctx.sourceMap().originalLinesSizes.getOrDefault(rangeEnd, 0);
        return TextRanges.range(rangeStart, 0, rangeEnd, rangeEndLineLength);
    }

    public static TextRange computeHelmExpressionToHighlightingTextRange(HelmInputFileContext helmContext, TextRange textRange) {
        List<TextRange> textRanges;
        GoTemplateTree goTemplateTree = helmContext.getGoTemplateTree();
        String sourceWithComments = helmContext.getSourceWithComments();
        if (goTemplateTree != null && sourceWithComments != null && !(textRanges = GoTemplateAstHelper.findNodesToHighlight(goTemplateTree, textRange, sourceWithComments).map(Node::location).map(location -> location.toTextRange(sourceWithComments)).toList()).isEmpty()) {
            return TextRanges.merge(textRanges);
        }
        return textRange;
    }

    public static SecondaryLocation computeShiftedSecondaryLocation(HelmInputFileContext ctx, SecondaryLocation secondaryLocation) {
        InputFile fileToRaiseOn = ctx.retrieveFileToRaiseOn(secondaryLocation);
        if (fileToRaiseOn == null || !fileToRaiseOn.equals(ctx.inputFile)) {
            return secondaryLocation;
        }
        TextRange range = LocationShifter.computeShiftedLocation(ctx, secondaryLocation.textRange);
        return new SecondaryLocation(range, secondaryLocation.message, secondaryLocation.filePath);
    }

    public static MarkedYamlEngineException shiftMarkedYamlException(HelmInputFileContext inputFileContext, MarkedYamlEngineException exception) {
        Optional<Mark> problemMark = exception.getProblemMark();
        if (problemMark.isPresent()) {
            Mark markInTransformedCode = problemMark.get();
            TextRange rangeInException = TextRanges.range(markInTransformedCode.getLine(), markInTransformedCode.getColumn(), markInTransformedCode.getLine(), markInTransformedCode.getColumn());
            TextRange shiftedRange = LocationShifter.computeShiftedLocation(inputFileContext, rangeInException);
            Mark shiftedMark = new Mark(markInTransformedCode.getName(), markInTransformedCode.getIndex(), shiftedRange.start().line(), shiftedRange.start().lineOffset(), markInTransformedCode.getBuffer(), markInTransformedCode.getPointer());
            return new ShiftedMarkedYamlEngineException(exception, shiftedMark);
        }
        return exception;
    }

    private static boolean isTextRangeValid(TextRange mixedTextRange, HelmInputFileContext currentCtx) {
        try {
            currentCtx.inputFile.newRange(mixedTextRange.start().line(), mixedTextRange.start().lineOffset(), mixedTextRange.end().line(), mixedTextRange.end().lineOffset());
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static class LinesShifting {
        private final Map<Integer, LineData> linesData = new TreeMap<Integer, LineData>();
        private final Map<Integer, Integer> originalLinesSizes = new HashMap<Integer, Integer>();

        public void addLineData(int transformedLine, int targetStartLine, int targetEndLine) {
            this.linesData.put(transformedLine, new LineData(targetStartLine, targetEndLine));
        }

        private boolean isNotInitialized() {
            return this.linesData.isEmpty() && this.originalLinesSizes.isEmpty();
        }

        private Optional<LineData> getClosestLineData(Integer lineNumber) {
            return this.linesData.entrySet().stream().dropWhile(p -> (Integer)p.getKey() < lineNumber).findFirst().map(Map.Entry::getValue);
        }

        private Integer getLastOriginalLine() {
            return this.originalLinesSizes.keySet().stream().sorted(Comparator.reverseOrder()).mapToInt(i -> i).findFirst().orElse(0);
        }
    }

    static final class LineData {
        private final Integer targetStartLine;
        private final Integer targetEndLine;

        public LineData(Integer targetStartLine, Integer targetEndLine) {
            this.targetStartLine = targetStartLine;
            this.targetEndLine = targetEndLine;
        }
    }
}

