/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.kubernetes.visitors;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import org.sonar.api.batch.rule.Checks;
import org.sonar.api.rule.RuleKey;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.IacCheck;
import org.sonar.iac.common.api.checks.InitContext;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.api.tree.impl.TextRange;
import org.sonar.iac.common.extension.DurationStatistics;
import org.sonar.iac.common.extension.visitors.ChecksVisitor;
import org.sonar.iac.kubernetes.visitors.HelmInputFileContext;
import org.sonar.iac.kubernetes.visitors.KubernetesCheckContext;
import org.sonar.iac.kubernetes.visitors.LocationShifter;
import org.sonar.iac.kubernetes.visitors.ProjectContext;
import org.sonar.iac.kubernetes.visitors.SecondaryLocationLocator;

public class KubernetesChecksVisitor
extends ChecksVisitor {
    protected static final String ENABLE_SECONDARY_LOCATIONS_IN_VALUES_YAML_KEY = "sonar.kubernetes.internal.helm.secondaryLocationsInValuesEnable";
    private final ProjectContext projectContext;

    public KubernetesChecksVisitor(Checks<IacCheck> checks, DurationStatistics statistics, ProjectContext projectContext) {
        super(checks, statistics);
        this.projectContext = projectContext;
    }

    @Override
    protected InitContext context(RuleKey ruleKey) {
        return new KubernetesContextAdapter(ruleKey);
    }

    public class KubernetesContextAdapter
    extends ChecksVisitor.ContextAdapter
    implements KubernetesCheckContext {
        private HelmInputFileContext currentCtx;
        private boolean shouldReportSecondaryInValues;

        public KubernetesContextAdapter(RuleKey ruleKey) {
            super(KubernetesChecksVisitor.this, ruleKey);
        }

        @Override
        public ProjectContext projectContext() {
            return KubernetesChecksVisitor.this.projectContext;
        }

        @Override
        public <T extends Tree> void register(Class<T> cls, BiConsumer<CheckContext, T> visitor) {
            KubernetesChecksVisitor.this.register(cls, KubernetesChecksVisitor.this.statistics.time(this.ruleKey.rule(), (ctx, tree) -> {
                this.currentCtx = (HelmInputFileContext)ctx;
                visitor.accept(this, tree);
            }));
        }

        @Override
        protected void reportIssue(@Nullable TextRange textRange, String message, List<SecondaryLocation> secondaryLocations) {
            TextRange shiftedTextRange = textRange;
            List<SecondaryLocation> allSecondaryLocations = new ArrayList<SecondaryLocation>();
            if (textRange != null) {
                shiftedTextRange = LocationShifter.shiftLocation(this.currentCtx, textRange);
                boolean isReportingEnabled = this.currentCtx.sensorContext.config().getBoolean(KubernetesChecksVisitor.ENABLE_SECONDARY_LOCATIONS_IN_VALUES_YAML_KEY).orElse(false);
                if (isReportingEnabled || this.shouldReportSecondaryInValues()) {
                    allSecondaryLocations = SecondaryLocationLocator.findSecondaryLocationsInAdditionalFiles(this.currentCtx, shiftedTextRange);
                }
            }
            List<SecondaryLocation> shiftedSecondaryLocations = secondaryLocations.stream().map(secondaryLocation -> LocationShifter.computeShiftedSecondaryLocation(this.currentCtx, secondaryLocation)).toList();
            allSecondaryLocations.addAll(shiftedSecondaryLocations);
            this.currentCtx.reportIssue(this.ruleKey, shiftedTextRange, message, allSecondaryLocations);
        }

        @Override
        public boolean shouldReportSecondaryInValues() {
            return this.shouldReportSecondaryInValues;
        }

        @Override
        public void setShouldReportSecondaryInValues(boolean shouldReport) {
            this.shouldReportSecondaryInValues = shouldReport;
        }
    }
}

