/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.kubernetes.visitors;

import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.iac.common.extension.visitors.InputFileContext;
import org.sonar.iac.helm.HelmFileSystem;
import org.sonar.iac.helm.tree.api.GoTemplateTree;
import org.sonar.iac.kubernetes.visitors.LocationShifter;

public class HelmInputFileContext
extends InputFileContext {
    @Nullable
    private GoTemplateTree goTemplateTree;
    private Map<String, InputFile> additionalFiles = new HashMap<String, InputFile>();
    @Nullable
    private String sourceWithComments;
    private final LocationShifter.LinesShifting linesShifting = new LocationShifter.LinesShifting();

    public HelmInputFileContext(SensorContext sensorContext, InputFile inputFile) {
        super(sensorContext, inputFile);
    }

    public void setAdditionalFiles(Map<String, InputFile> additionalFiles) {
        this.additionalFiles = Collections.unmodifiableMap(additionalFiles);
    }

    public boolean hasAdditionalFile(String filePath) {
        return this.additionalFiles.containsKey(filePath);
    }

    @CheckForNull
    public InputFile getValuesFile() {
        return this.additionalFiles.get("values.yaml");
    }

    public Map<String, InputFile> getAdditionalFiles() {
        return Collections.unmodifiableMap(this.additionalFiles);
    }

    @CheckForNull
    public GoTemplateTree getGoTemplateTree() {
        return this.goTemplateTree;
    }

    public void setGoTemplateTree(@Nullable GoTemplateTree goTemplateTree) {
        this.goTemplateTree = goTemplateTree;
    }

    public void setSourceWithComments(@Nullable String sourceWithComments) {
        this.sourceWithComments = sourceWithComments;
    }

    @CheckForNull
    public String getSourceWithComments() {
        return this.sourceWithComments;
    }

    public boolean isInChartRootDirectory() {
        Path rootChartDirectory = HelmFileSystem.retrieveHelmProjectFolder(Path.of(this.inputFile.uri()), this.sensorContext.fileSystem());
        return this.inputFile.path().getParent() != null && this.inputFile.path().getParent().equals(rootChartDirectory);
    }

    public LocationShifter.LinesShifting sourceMap() {
        return this.linesShifting;
    }
}

