/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.kubernetes.plugin.predicates;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.util.Set;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.InputFile;

public class KubernetesFilePredicate
implements FilePredicate {
    private static final Pattern LINE_TERMINATOR = Pattern.compile("[\\n\\r\\u2028\\u2029]");
    private static final Set<String> IDENTIFIER = Set.of("apiVersion", "kind", "metadata");
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesFilePredicate.class);
    private static final int DEFAULT_BUFFER_SIZE = 8192;

    @Override
    public boolean apply(InputFile inputFile) {
        return KubernetesFilePredicate.hasKubernetesObjectStructure(inputFile);
    }

    private static boolean hasKubernetesObjectStructure(InputFile inputFile) {
        int identifierCount = 0;
        boolean hasExpectedIdentifier = false;
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(inputFile.inputStream());){
            String[] lines;
            byte[] bytes = bufferedInputStream.readNBytes(8192);
            String text = new String(bytes, inputFile.charset());
            for (String line : lines = LINE_TERMINATOR.split(text)) {
                if (IDENTIFIER.stream().anyMatch(line::startsWith)) {
                    ++identifierCount;
                } else if ("---".equals(line)) {
                    identifierCount = 0;
                }
                if (identifierCount != IDENTIFIER.size()) continue;
                hasExpectedIdentifier = true;
            }
        }
        catch (IOException e) {
            LOG.error("Unable to read file: {}.", (Object)inputFile);
            LOG.error(e.getMessage());
        }
        if (hasExpectedIdentifier) {
            return true;
        }
        LOG.debug("File without Kubernetes identifier: {}", (Object)inputFile);
        return false;
    }
}

