/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.kubernetes.plugin;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.SonarRuntime;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.FilePredicates;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.rule.CheckFactory;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.issue.NoSonarFilter;
import org.sonar.api.measures.FileLinesContextFactory;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.checks.Trilean;
import org.sonar.iac.common.extension.DurationStatistics;
import org.sonar.iac.common.extension.TreeParser;
import org.sonar.iac.common.extension.visitors.InputFileContext;
import org.sonar.iac.common.extension.visitors.TreeVisitor;
import org.sonar.iac.common.yaml.YamlSensor;
import org.sonar.iac.common.yaml.visitors.YamlMetricsVisitor;
import org.sonar.iac.helm.HelmEvaluator;
import org.sonar.iac.helm.HelmFileSystem;
import org.sonar.iac.kubernetes.checks.KubernetesCheckList;
import org.sonar.iac.kubernetes.plugin.HelmProcessor;
import org.sonar.iac.kubernetes.plugin.KubernetesLanguage;
import org.sonar.iac.kubernetes.plugin.KubernetesParser;
import org.sonar.iac.kubernetes.plugin.KubernetesParserStatistics;
import org.sonar.iac.kubernetes.plugin.predicates.KubernetesOrHelmFilePredicate;
import org.sonar.iac.kubernetes.visitors.HelmInputFileContext;
import org.sonar.iac.kubernetes.visitors.KubernetesChecksVisitor;
import org.sonar.iac.kubernetes.visitors.KubernetesHighlightingVisitor;
import org.sonar.iac.kubernetes.visitors.ProjectContext;

public class KubernetesSensor
extends YamlSensor {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesSensor.class);
    private static final String HELM_ACTIVATION_KEY = "sonar.kubernetes.internal.helm.enable";
    private final HelmEvaluator helmEvaluator;
    final ProjectContext.Builder projectContextBuilder = ProjectContext.builder();
    private HelmProcessor helmProcessor;
    private final KubernetesParserStatistics kubernetesParserStatistics = new KubernetesParserStatistics();

    public KubernetesSensor(SonarRuntime sonarRuntime, FileLinesContextFactory fileLinesContextFactory, CheckFactory checkFactory, NoSonarFilter noSonarFilter, KubernetesLanguage language, HelmEvaluator helmEvaluator) {
        super(sonarRuntime, fileLinesContextFactory, checkFactory, noSonarFilter, language, KubernetesCheckList.checks());
        this.helmEvaluator = helmEvaluator;
    }

    @Override
    protected void initContext(SensorContext sensorContext) {
        if (this.shouldEnableHelmAnalysis(sensorContext) && this.helmProcessor == null) {
            LOG.debug("Initializing Helm processor");
            HelmFileSystem helmFileSystem = new HelmFileSystem(sensorContext.fileSystem());
            this.helmProcessor = new HelmProcessor(this.helmEvaluator, helmFileSystem);
            this.helmProcessor.initialize();
        } else {
            LOG.debug("Skipping initialization of Helm processor");
        }
    }

    void checkExistingLimitRange(List<InputFile> inputFiles) {
        for (InputFile inputFile : inputFiles) {
            try {
                if (!inputFile.contents().contains("LimitRange")) continue;
                LOG.debug("LimitRange detected, related rules will be suppressed");
                this.projectContextBuilder.setLimitRange(Trilean.TRUE);
                return;
            }
            catch (IOException e) {
                LOG.debug("IOException while detecting LimitRange, related rules will be suppressed");
                this.projectContextBuilder.setLimitRange(Trilean.UNKNOWN);
                return;
            }
        }
    }

    @Override
    protected List<InputFile> inputFiles(SensorContext sensorContext) {
        List<InputFile> inputFiles = super.inputFiles(sensorContext);
        this.checkExistingLimitRange(inputFiles);
        return inputFiles;
    }

    @Override
    public void describe(SensorDescriptor descriptor) {
        descriptor.onlyOnLanguages("yaml").name("IaC " + this.language.getName() + " Sensor");
    }

    @Override
    protected TreeParser<? extends Tree> treeParser() {
        return new KubernetesParser(this.helmProcessor, this.kubernetesParserStatistics);
    }

    @Override
    protected List<TreeVisitor<InputFileContext>> visitors(SensorContext sensorContext, DurationStatistics statistics) {
        ArrayList<TreeVisitor<InputFileContext>> visitors = new ArrayList<TreeVisitor<InputFileContext>>();
        if (this.isNotSonarLintContext(sensorContext)) {
            visitors.add(new KubernetesHighlightingVisitor());
            visitors.add(new YamlMetricsVisitor(this.fileLinesContextFactory, this.noSonarFilter));
        }
        visitors.add(new KubernetesChecksVisitor(this.checks, statistics, this.projectContextBuilder.build()));
        return visitors;
    }

    @Override
    protected String repositoryKey() {
        return "kubernetes";
    }

    @Override
    protected String getActivationSettingKey() {
        return "sonar.kubernetes.activate";
    }

    @Override
    protected FilePredicate mainFilePredicate(SensorContext sensorContext) {
        FilePredicates predicates = sensorContext.fileSystem().predicates();
        return predicates.and(predicates.hasType(InputFile.Type.MAIN), this.customFilePredicate(sensorContext));
    }

    @Override
    protected FilePredicate customFilePredicate(SensorContext sensorContext) {
        return new KubernetesOrHelmFilePredicate(sensorContext);
    }

    @Override
    protected void afterExecute() {
        this.kubernetesParserStatistics.logStatistics();
    }

    @Override
    protected InputFileContext createInputFileContext(SensorContext sensorContext, InputFile inputFile) {
        return new HelmInputFileContext(sensorContext, inputFile);
    }

    private boolean shouldEnableHelmAnalysis(SensorContext sensorContext) {
        boolean isNotSonarLintContext = this.isNotSonarLintContext(sensorContext);
        boolean isHelmAnalysisEnabled = sensorContext.config().getBoolean(HELM_ACTIVATION_KEY).orElse(true);
        boolean isHelmEvaluatorExecutableAvailable = HelmProcessor.isHelmEvaluatorExecutableAvailable();
        LOG.debug("Checking conditions for enabling Helm analysis: isNotSonarLintContext={}, isHelmActivationFlagTrue={}, isHelmEvaluatorExecutableAvailable={}", isNotSonarLintContext, isHelmAnalysisEnabled, isHelmEvaluatorExecutableAvailable);
        if (isNotSonarLintContext && isHelmAnalysisEnabled && !isHelmEvaluatorExecutableAvailable) {
            LOG.info("Helm analysis is not supported for the current platform");
        }
        return isNotSonarLintContext && isHelmAnalysisEnabled && isHelmEvaluatorExecutableAvailable;
    }

    void setHelmProcessorForTesting(HelmProcessor helmProcessor) {
        this.helmProcessor = helmProcessor;
    }
}

