/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.kubernetes.checks;

import org.sonar.check.Rule;
import org.sonar.iac.common.yaml.object.BlockObject;
import org.sonar.iac.kubernetes.checks.AbstractLimitsCheck;

@Rule(key="S6870")
public class EphemeralStorageLimitCheck
extends AbstractLimitsCheck {
    private static final String MESSAGE = "Specify a storage limit for this container.";
    private static final String KEY = "ephemeral-storage";

    @Override
    String getLimitAttributeKey() {
        return KEY;
    }

    @Override
    String getMessage() {
        return MESSAGE;
    }

    @Override
    void registerObjectCheck() {
        this.register("Pod", (BlockObject pod) -> pod.blocks("containers").filter(container -> container.blocks("volumeMounts").findAny().isPresent()).forEach(this::reportMissingLimit));
        this.register(KIND_WITH_TEMPLATE, (BlockObject obj) -> obj.block("template").block("spec").blocks("containers").filter(container -> container.blocks("volumeMounts").findAny().isPresent()).forEach(this::reportMissingLimit));
    }
}

